# 1 "js_lexer.mll"
 

(* Js_of_ocaml compiler
 * Copyright (C) 2013 Hugo Heuzard
 *)

(* Yoann Padioleau
 *
 * Copyright (C) 2010 Facebook
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation, with the
 * special exception on linking described in file license.txt.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the file
 * license.txt for more details.
 *)

open Js_token

let tok lexbuf = Lexing.lexeme lexbuf

let keyword_table =
  let h = Hashtbl.create 17 in
  List.iter (fun (s,f) -> Hashtbl.add h s f ) [

    "catch",      (fun ii -> T_CATCH ii);
    "finally",    (fun ii -> T_FINALLY ii);
    "in",         (fun ii -> T_IN ii);
    "instanceof", (fun ii -> T_INSTANCEOF ii);

    "else",       (fun ii -> T_ELSE ii);
    "while",      (fun ii -> T_WHILE ii);

    "break",      (fun ii -> T_BREAK ii);
    "case",       (fun ii -> T_CASE ii);
    "continue",   (fun ii -> T_CONTINUE ii);
    "default",    (fun ii -> T_DEFAULT ii);
    "delete",     (fun ii -> T_DELETE ii);
    "do",         (fun ii -> T_DO ii);
    "else",       (fun ii -> T_ELSE ii);
    "for",        (fun ii -> T_FOR ii);
    "function",   (fun ii -> T_FUNCTION ii);
    "if",         (fun ii -> T_IF ii);
    "new",        (fun ii -> T_NEW ii);
    "return",     (fun ii -> T_RETURN ii);
    "switch",     (fun ii -> T_SWITCH ii);
    "this",       (fun ii -> T_THIS ii);
    "throw",      (fun ii -> T_THROW ii);
    "try",        (fun ii -> T_TRY ii);
    "typeof",     (fun ii -> T_TYPEOF ii);
    "var",        (fun ii -> T_VAR ii);
    "void",       (fun ii -> T_VOID ii);
    "while",      (fun ii -> T_WHILE ii);
    "with",       (fun ii -> T_WITH ii);
    "null",       (fun ii -> T_NULL ii);
    "false",      (fun ii -> T_FALSE ii);
    "true",       (fun ii -> T_TRUE ii);
    "debugger",   (fun ii -> T_DEBUGGER ii);
  ];
  h


# 69 "js_lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base = 
   "\000\000\197\255\198\255\200\255\081\000\103\000\160\000\207\255\
    \003\000\031\000\035\000\083\000\100\000\078\000\081\000\084\000\
    \085\000\127\000\109\000\241\255\242\255\243\255\244\255\235\000\
    \246\255\247\255\248\255\249\255\250\255\251\255\252\255\001\000\
    \003\000\120\000\199\255\153\000\255\255\245\000\011\001\021\001\
    \031\001\220\255\240\255\219\255\239\255\087\000\238\255\103\000\
    \237\255\104\000\236\255\230\255\107\000\235\255\110\000\228\255\
    \227\255\224\255\232\255\223\255\231\255\222\255\221\255\218\255\
    \043\001\055\001\065\001\120\001\102\000\252\255\253\255\143\001\
    \181\001\255\255\204\001\254\255\242\001\009\002\047\002\161\000\
    \251\255\252\255\004\000\255\255\254\255\129\000\251\255\252\255\
    \253\255\254\255\047\000\255\255\214\000\252\255\253\255\048\000\
    \255\255\254\255\053\002\166\002\251\255\167\002\254\255\005\000\
    \126\000\255\255\139\000\166\000\169\002\179\002\116\001\255\255\
    ";
  Lexing.lex_backtrk = 
   "\255\255\255\255\255\255\255\255\054\000\054\000\050\000\255\255\
    \046\000\043\000\042\000\041\000\040\000\039\000\038\000\047\000\
    \049\000\044\000\045\000\255\255\255\255\255\255\255\255\010\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\003\000\
    \002\000\056\000\255\255\001\000\255\255\054\000\255\255\053\000\
    \255\255\255\255\255\255\255\255\255\255\021\000\255\255\022\000\
    \255\255\026\000\255\255\255\255\030\000\255\255\029\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \054\000\052\000\255\255\051\000\255\255\255\255\255\255\002\000\
    \002\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\002\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\003\000\255\255\255\255\255\255\255\255\002\000\
    \255\255\255\255\000\000\255\255\255\255\002\000\255\255\001\000\
    \003\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    ";
  Lexing.lex_default = 
   "\001\000\000\000\000\000\000\000\255\255\255\255\255\255\000\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\000\000\000\000\000\000\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\255\
    \255\255\255\255\000\000\035\000\000\000\255\255\255\255\255\255\
    \255\255\000\000\000\000\000\000\000\000\255\255\000\000\255\255\
    \000\000\255\255\000\000\000\000\255\255\000\000\255\255\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\255\255\255\255\255\255\070\000\000\000\000\000\255\255\
    \255\255\000\000\255\255\000\000\255\255\255\255\255\255\081\000\
    \000\000\000\000\255\255\000\000\000\000\087\000\000\000\000\000\
    \000\000\000\000\091\000\000\000\094\000\000\000\000\000\097\000\
    \000\000\000\000\255\255\101\000\000\000\101\000\000\000\255\255\
    \255\255\000\000\255\255\255\255\255\255\255\255\255\255\000\000\
    ";
  Lexing.lex_trans = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\032\000\030\000\030\000\032\000\031\000\084\000\102\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \032\000\015\000\003\000\032\000\006\000\009\000\018\000\003\000\
    \027\000\026\000\010\000\012\000\021\000\011\000\023\000\033\000\
    \005\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\020\000\022\000\014\000\016\000\013\000\019\000\
    \063\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\025\000\062\000\024\000\008\000\006\000\
    \061\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\029\000\017\000\028\000\007\000\064\000\
    \060\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\053\000\052\000\049\000\050\000\058\000\
    \059\000\047\000\045\000\042\000\046\000\064\000\038\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\004\000\
    \004\000\057\000\036\000\255\255\048\000\051\000\255\255\035\000\
    \055\000\054\000\041\000\056\000\038\000\105\000\107\000\108\000\
    \089\000\000\000\000\000\000\000\000\000\034\000\038\000\000\000\
    \000\000\000\000\000\000\000\000\043\000\000\000\000\000\066\000\
    \000\000\000\000\073\000\083\000\006\000\000\000\108\000\000\000\
    \083\000\000\000\000\000\000\000\038\000\000\000\000\000\000\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\000\000\071\000\088\000\090\000\072\000\066\000\
    \000\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\044\000\000\000\082\000\000\000\006\000\
    \002\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\255\255\
    \255\255\000\000\095\000\096\000\000\000\000\000\040\000\000\000\
    \040\000\000\000\038\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\000\000\038\000\037\000\037\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\064\000\069\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\004\000\
    \004\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\000\000\038\000\110\000\000\000\000\000\
    \000\000\086\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\110\000\000\000\111\000\000\000\
    \000\000\255\255\000\000\111\000\038\000\000\000\000\000\000\000\
    \000\000\080\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\067\000\067\000\067\000\067\000\067\000\067\000\076\000\
    \076\000\076\000\076\000\076\000\076\000\076\000\076\000\076\000\
    \076\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \076\000\076\000\076\000\076\000\076\000\076\000\093\000\000\000\
    \000\000\067\000\067\000\067\000\067\000\067\000\067\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\000\000\
    \076\000\076\000\076\000\076\000\076\000\076\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\075\000\075\000\075\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\075\000\075\000\075\000\
    \075\000\075\000\075\000\000\000\000\000\000\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\077\000\077\000\077\000\077\000\077\000\077\000\
    \077\000\077\000\077\000\077\000\000\000\075\000\075\000\075\000\
    \075\000\075\000\075\000\077\000\077\000\077\000\077\000\077\000\
    \077\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\078\000\078\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \000\000\000\000\000\000\077\000\077\000\077\000\077\000\077\000\
    \077\000\000\000\000\000\000\000\000\000\000\000\000\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\075\000\075\000\
    \075\000\000\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \102\000\255\255\108\000\103\000\255\255\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\110\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\108\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \104\000\255\255\000\000\110\000\000\000\000\000\000\000\000\000\
    \000\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
    \109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
    \109\000\109\000\109\000\109\000\109\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\100\000\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000";
  Lexing.lex_check = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\031\000\032\000\000\000\082\000\103\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\000\000\000\000\032\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \008\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\009\000\000\000\000\000\000\000\
    \010\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\
    \011\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\013\000\013\000\014\000\014\000\012\000\
    \011\000\015\000\016\000\018\000\045\000\005\000\004\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\012\000\033\000\035\000\047\000\049\000\035\000\033\000\
    \052\000\052\000\018\000\054\000\005\000\104\000\106\000\107\000\
    \085\000\255\255\255\255\255\255\255\255\033\000\004\000\255\255\
    \255\255\255\255\255\255\255\255\017\000\255\255\255\255\005\000\
    \255\255\255\255\068\000\079\000\006\000\255\255\107\000\255\255\
    \079\000\255\255\255\255\255\255\005\000\255\255\255\255\255\255\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\255\255\068\000\085\000\085\000\068\000\005\000\
    \255\255\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\017\000\255\255\079\000\255\255\006\000\
    \000\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\006\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\037\000\037\000\037\000\
    \037\000\037\000\037\000\037\000\037\000\037\000\037\000\090\000\
    \095\000\255\255\092\000\092\000\255\255\255\255\038\000\255\255\
    \038\000\255\255\037\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\040\000\
    \040\000\040\000\040\000\040\000\040\000\040\000\040\000\040\000\
    \040\000\255\255\037\000\064\000\064\000\064\000\064\000\064\000\
    \064\000\064\000\064\000\064\000\064\000\065\000\068\000\065\000\
    \065\000\065\000\065\000\065\000\065\000\065\000\065\000\065\000\
    \065\000\066\000\066\000\066\000\066\000\066\000\066\000\066\000\
    \066\000\066\000\066\000\255\255\065\000\110\000\255\255\255\255\
    \255\255\085\000\066\000\066\000\066\000\066\000\066\000\066\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\110\000\255\255\110\000\255\255\
    \255\255\035\000\255\255\110\000\065\000\255\255\255\255\255\255\
    \255\255\079\000\066\000\066\000\066\000\066\000\066\000\066\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\067\000\067\000\067\000\067\000\067\000\067\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \071\000\071\000\071\000\071\000\071\000\071\000\092\000\255\255\
    \255\255\067\000\067\000\067\000\067\000\067\000\067\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\072\000\072\000\072\000\
    \072\000\072\000\072\000\072\000\072\000\072\000\072\000\255\255\
    \071\000\071\000\071\000\071\000\071\000\071\000\072\000\072\000\
    \072\000\072\000\072\000\072\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\074\000\074\000\074\000\
    \074\000\074\000\074\000\255\255\255\255\255\255\072\000\072\000\
    \072\000\072\000\072\000\072\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\076\000\076\000\076\000\076\000\076\000\076\000\
    \076\000\076\000\076\000\076\000\255\255\074\000\074\000\074\000\
    \074\000\074\000\074\000\076\000\076\000\076\000\076\000\076\000\
    \076\000\077\000\077\000\077\000\077\000\077\000\077\000\077\000\
    \077\000\077\000\077\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\077\000\077\000\077\000\077\000\077\000\077\000\
    \255\255\255\255\255\255\076\000\076\000\076\000\076\000\076\000\
    \076\000\255\255\255\255\255\255\255\255\255\255\255\255\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\255\255\077\000\077\000\077\000\077\000\077\000\077\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \098\000\098\000\098\000\098\000\098\000\098\000\098\000\098\000\
    \099\000\101\000\108\000\099\000\101\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\109\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\108\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \099\000\101\000\255\255\109\000\255\255\255\255\255\255\255\255\
    \255\255\108\000\108\000\108\000\108\000\108\000\108\000\108\000\
    \108\000\108\000\108\000\109\000\109\000\109\000\109\000\109\000\
    \109\000\109\000\109\000\109\000\109\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\099\000\101\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255";
  Lexing.lex_base_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\001\000\011\000\000\000\007\000\
    ";
  Lexing.lex_backtrk_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    ";
  Lexing.lex_default_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    ";
  Lexing.lex_trans_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\001\000\001\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \001\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000";
  Lexing.lex_check_code = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\107\000\108\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \107\000\108\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\108\000\108\000\108\000\108\000\108\000\108\000\108\000\
    \108\000\108\000\108\000\109\000\109\000\109\000\109\000\109\000\
    \109\000\109\000\109\000\109\000\109\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255";
  Lexing.lex_code = 
   "\255\002\255\255\003\255\255\000\002\001\003\255";
}

let rec initial tokinfo prev lexbuf =
    __ocaml_lex_initial_rec tokinfo prev lexbuf 0
and __ocaml_lex_initial_rec tokinfo prev lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 80 "js_lexer.mll"
         (
      let info = tokinfo lexbuf in
      let buf = Buffer.create 127 in
      let nl = ref false in
      st_comment buf nl lexbuf;
      let content = Buffer.contents buf in
      if !nl
      then TCommentML(info,content)
      else TComment(info,content)
    )
# 497 "js_lexer.ml"

  | 1 ->
let
# 91 "js_lexer.mll"
                             cmt
# 503 "js_lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 91 "js_lexer.mll"
                                  ( TComment(tokinfo lexbuf,cmt) )
# 507 "js_lexer.ml"

  | 2 ->
let
# 93 "js_lexer.mll"
                     cmt
# 513 "js_lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 93 "js_lexer.mll"
                                  ( TCommentSpace(tokinfo lexbuf,cmt) )
# 517 "js_lexer.ml"

  | 3 ->
# 94 "js_lexer.mll"
            (
      lexbuf.Lexing.lex_curr_p <- { lexbuf.Lexing.lex_curr_p with
                                      Lexing.pos_lnum = lexbuf.Lexing.lex_curr_p.Lexing.pos_lnum + 1 };
      TCommentNewline(tokinfo lexbuf,"") )
# 525 "js_lexer.ml"

  | 4 ->
# 103 "js_lexer.mll"
        ( T_LCURLY (tokinfo lexbuf); )
# 530 "js_lexer.ml"

  | 5 ->
# 104 "js_lexer.mll"
        ( T_RCURLY (tokinfo lexbuf); )
# 535 "js_lexer.ml"

  | 6 ->
# 106 "js_lexer.mll"
        ( T_LPAREN (tokinfo lexbuf); )
# 540 "js_lexer.ml"

  | 7 ->
# 107 "js_lexer.mll"
        ( T_RPAREN (tokinfo lexbuf); )
# 545 "js_lexer.ml"

  | 8 ->
# 109 "js_lexer.mll"
        ( T_LBRACKET (tokinfo lexbuf); )
# 550 "js_lexer.ml"

  | 9 ->
# 110 "js_lexer.mll"
        ( T_RBRACKET (tokinfo lexbuf); )
# 555 "js_lexer.ml"

  | 10 ->
# 111 "js_lexer.mll"
        ( T_PERIOD (tokinfo lexbuf); )
# 560 "js_lexer.ml"

  | 11 ->
# 112 "js_lexer.mll"
        ( T_SEMICOLON (tokinfo lexbuf); )
# 565 "js_lexer.ml"

  | 12 ->
# 113 "js_lexer.mll"
        ( T_COMMA (tokinfo lexbuf); )
# 570 "js_lexer.ml"

  | 13 ->
# 114 "js_lexer.mll"
        ( T_COLON (tokinfo lexbuf); )
# 575 "js_lexer.ml"

  | 14 ->
# 115 "js_lexer.mll"
        ( T_PLING (tokinfo lexbuf); )
# 580 "js_lexer.ml"

  | 15 ->
# 116 "js_lexer.mll"
         ( T_AND (tokinfo lexbuf); )
# 585 "js_lexer.ml"

  | 16 ->
# 117 "js_lexer.mll"
         ( T_OR (tokinfo lexbuf); )
# 590 "js_lexer.ml"

  | 17 ->
# 118 "js_lexer.mll"
          ( T_STRICT_EQUAL (tokinfo lexbuf); )
# 595 "js_lexer.ml"

  | 18 ->
# 119 "js_lexer.mll"
          ( T_STRICT_NOT_EQUAL (tokinfo lexbuf); )
# 600 "js_lexer.ml"

  | 19 ->
# 120 "js_lexer.mll"
         ( T_LESS_THAN_EQUAL (tokinfo lexbuf); )
# 605 "js_lexer.ml"

  | 20 ->
# 121 "js_lexer.mll"
         ( T_GREATER_THAN_EQUAL (tokinfo lexbuf); )
# 610 "js_lexer.ml"

  | 21 ->
# 122 "js_lexer.mll"
         ( T_EQUAL (tokinfo lexbuf); )
# 615 "js_lexer.ml"

  | 22 ->
# 123 "js_lexer.mll"
         ( T_NOT_EQUAL (tokinfo lexbuf); )
# 620 "js_lexer.ml"

  | 23 ->
# 124 "js_lexer.mll"
         (
      let cpi = tokinfo lexbuf in
      match prev with
        | Some p when (Js_token.info_of_tok p).Parse_info.line = cpi.Parse_info.line ->
          T_INCR_NB(cpi)
        | _ -> T_INCR(cpi) )
# 630 "js_lexer.ml"

  | 24 ->
# 130 "js_lexer.mll"
         (
      let cpi = tokinfo lexbuf in
      match prev with
        | Some p when (Js_token.info_of_tok p).Parse_info.line = cpi.Parse_info.line ->
          T_DECR_NB(cpi)
        | _ -> T_DECR(cpi) )
# 640 "js_lexer.ml"

  | 25 ->
# 136 "js_lexer.mll"
          ( T_LSHIFT_ASSIGN (tokinfo lexbuf); )
# 645 "js_lexer.ml"

  | 26 ->
# 137 "js_lexer.mll"
         ( T_LSHIFT (tokinfo lexbuf); )
# 650 "js_lexer.ml"

  | 27 ->
# 138 "js_lexer.mll"
          ( T_RSHIFT_ASSIGN (tokinfo lexbuf); )
# 655 "js_lexer.ml"

  | 28 ->
# 139 "js_lexer.mll"
           ( T_RSHIFT3_ASSIGN (tokinfo lexbuf); )
# 660 "js_lexer.ml"

  | 29 ->
# 140 "js_lexer.mll"
          ( T_RSHIFT3 (tokinfo lexbuf); )
# 665 "js_lexer.ml"

  | 30 ->
# 141 "js_lexer.mll"
         ( T_RSHIFT (tokinfo lexbuf); )
# 670 "js_lexer.ml"

  | 31 ->
# 142 "js_lexer.mll"
         ( T_PLUS_ASSIGN (tokinfo lexbuf); )
# 675 "js_lexer.ml"

  | 32 ->
# 143 "js_lexer.mll"
         ( T_MINUS_ASSIGN (tokinfo lexbuf); )
# 680 "js_lexer.ml"

  | 33 ->
# 145 "js_lexer.mll"
         ( T_MULT_ASSIGN (tokinfo lexbuf); )
# 685 "js_lexer.ml"

  | 34 ->
# 146 "js_lexer.mll"
         ( T_MOD_ASSIGN (tokinfo lexbuf); )
# 690 "js_lexer.ml"

  | 35 ->
# 147 "js_lexer.mll"
         ( T_BIT_AND_ASSIGN (tokinfo lexbuf); )
# 695 "js_lexer.ml"

  | 36 ->
# 148 "js_lexer.mll"
         ( T_BIT_OR_ASSIGN (tokinfo lexbuf); )
# 700 "js_lexer.ml"

  | 37 ->
# 149 "js_lexer.mll"
         ( T_BIT_XOR_ASSIGN (tokinfo lexbuf); )
# 705 "js_lexer.ml"

  | 38 ->
# 150 "js_lexer.mll"
        ( T_LESS_THAN (tokinfo lexbuf); )
# 710 "js_lexer.ml"

  | 39 ->
# 151 "js_lexer.mll"
        ( T_GREATER_THAN (tokinfo lexbuf); )
# 715 "js_lexer.ml"

  | 40 ->
# 152 "js_lexer.mll"
        ( T_PLUS (tokinfo lexbuf); )
# 720 "js_lexer.ml"

  | 41 ->
# 153 "js_lexer.mll"
        ( T_MINUS (tokinfo lexbuf); )
# 725 "js_lexer.ml"

  | 42 ->
# 154 "js_lexer.mll"
        ( T_MULT (tokinfo lexbuf); )
# 730 "js_lexer.ml"

  | 43 ->
# 156 "js_lexer.mll"
        ( T_MOD (tokinfo lexbuf); )
# 735 "js_lexer.ml"

  | 44 ->
# 157 "js_lexer.mll"
        ( T_BIT_OR (tokinfo lexbuf); )
# 740 "js_lexer.ml"

  | 45 ->
# 158 "js_lexer.mll"
        ( T_BIT_AND (tokinfo lexbuf); )
# 745 "js_lexer.ml"

  | 46 ->
# 159 "js_lexer.mll"
        ( T_BIT_XOR (tokinfo lexbuf); )
# 750 "js_lexer.ml"

  | 47 ->
# 160 "js_lexer.mll"
        ( T_NOT (tokinfo lexbuf); )
# 755 "js_lexer.ml"

  | 48 ->
# 161 "js_lexer.mll"
        ( T_BIT_NOT (tokinfo lexbuf); )
# 760 "js_lexer.ml"

  | 49 ->
# 162 "js_lexer.mll"
        ( T_ASSIGN (tokinfo lexbuf); )
# 765 "js_lexer.ml"

  | 50 ->
# 167 "js_lexer.mll"
                                                         (
      let s = tok lexbuf in
      let info = tokinfo lexbuf in
      try
        let f = Hashtbl.find keyword_table s in
        f info (* need case insensitive ? *)
      with
        | Not_found -> T_IDENTIFIER (s, info)
    )
# 778 "js_lexer.ml"

  | 51 ->
# 181 "js_lexer.mll"
                       (
      let s = tok lexbuf in
      let info = tokinfo lexbuf in
      T_NUMBER (s, Int64.(to_float (of_string s)), info)
    )
# 787 "js_lexer.ml"

  | 52 ->
# 186 "js_lexer.mll"
                  (
      let s = tok lexbuf in
      let s' = String.sub s 1 (String.length s - 1 ) in
      let info = tokinfo lexbuf in
      T_NUMBER (s, Int64.(to_float (of_string ("0o"^s'))), info)
    )
# 797 "js_lexer.ml"

  | 53 ->
# 193 "js_lexer.mll"
                                                                    (
      let s = tok lexbuf in
      let info = tokinfo lexbuf in
      T_NUMBER (s, float_of_string s,info)
    )
# 806 "js_lexer.ml"

  | 54 ->
# 200 "js_lexer.mll"
                            (
      let s = tok lexbuf in
      let info = tokinfo lexbuf in
      T_NUMBER (s, float_of_string s, info)
    )
# 815 "js_lexer.ml"

  | 55 ->
let
# 209 "js_lexer.mll"
                 quote
# 821 "js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 209 "js_lexer.mll"
                       (
      let info = tokinfo lexbuf in
      let buf = Buffer.create 127 in
      string_quote quote buf lexbuf;
      let s = Buffer.contents buf in
      (* s does not contain the enclosing "'" but the info does *)
      T_STRING (s, info)
    )
# 832 "js_lexer.ml"

  | 56 ->
# 234 "js_lexer.mll"
               (
    let s = tok lexbuf in
      let info = tokinfo lexbuf in

      match prev with
      | Some (
            T_IDENTIFIER _
          | T_NUMBER _ | T_STRING _ | T_REGEX _
          | T_FALSE _ | T_TRUE _ | T_NULL _
          | T_THIS _
          | T_INCR _ | T_DECR _
          | T_RBRACKET _ | T_RPAREN _
        ) -> begin match s with
          | "/" -> T_DIV (info);
          | "/=" -> T_DIV_ASSIGN info
          | _ -> assert false
        end
      | _ ->
          (* raise (Token t); *)
          let buf = Buffer.create 127 in
          Buffer.add_string buf s;
          regexp buf lexbuf;
          T_REGEX (Buffer.contents buf, info)
    )
# 860 "js_lexer.ml"

  | 57 ->
# 263 "js_lexer.mll"
        ( EOF (tokinfo lexbuf) )
# 865 "js_lexer.ml"

  | 58 ->
# 265 "js_lexer.mll"
      (
      (* Format.eprintf "LEXER:unrecognised symbol, in token rule: %s@." (tok lexbuf); *)
      TUnknown (tokinfo lexbuf, tok lexbuf)
    )
# 873 "js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; 
      __ocaml_lex_initial_rec tokinfo prev lexbuf __ocaml_lex_state

and string_escape quote buf lexbuf =
    __ocaml_lex_string_escape_rec quote buf lexbuf 68
and __ocaml_lex_string_escape_rec quote buf lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 272 "js_lexer.mll"
        ( Buffer.add_string buf "\\\\" )
# 885 "js_lexer.ml"

  | 1 ->
# 274 "js_lexer.mll"
                            (
      Buffer.add_char buf '\\';
      Buffer.add_string buf (Lexing.lexeme lexbuf) )
# 892 "js_lexer.ml"

  | 2 ->
let
# 277 "js_lexer.mll"
          c
# 898 "js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 278 "js_lexer.mll"
    ( if c <> '\'' && c <> '\"' then Buffer.add_char buf '\\';
      Buffer.add_char buf c )
# 903 "js_lexer.ml"

  | 3 ->
# 280 "js_lexer.mll"
        ( Format.eprintf  "LEXER: WIERD end of file in string_escape@."; ())
# 908 "js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; 
      __ocaml_lex_string_escape_rec quote buf lexbuf __ocaml_lex_state

and string_quote q buf lexbuf =
    __ocaml_lex_string_quote_rec q buf lexbuf 79
and __ocaml_lex_string_quote_rec q buf lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 283 "js_lexer.mll"
                 q'
# 921 "js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 283 "js_lexer.mll"
                    (
    if q = q'
    then ()
    else (Buffer.add_char buf q'; string_quote q buf lexbuf) )
# 928 "js_lexer.ml"

  | 1 ->
# 287 "js_lexer.mll"
           ( string_quote q buf lexbuf )
# 933 "js_lexer.ml"

  | 2 ->
# 288 "js_lexer.mll"
         (
      string_escape q buf lexbuf;
      string_quote q buf lexbuf
    )
# 941 "js_lexer.ml"

  | 3 ->
let
# 292 "js_lexer.mll"
          x
# 947 "js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 292 "js_lexer.mll"
                   ( Buffer.add_char buf x; string_quote q buf lexbuf )
# 951 "js_lexer.ml"

  | 4 ->
# 293 "js_lexer.mll"
        ( Format.eprintf  "LEXER: WIERD end of file in quoted string@."; ())
# 956 "js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; 
      __ocaml_lex_string_quote_rec q buf lexbuf __ocaml_lex_state

and regexp buf lexbuf =
    __ocaml_lex_regexp_rec buf lexbuf 85
and __ocaml_lex_regexp_rec buf lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 297 "js_lexer.mll"
               x
# 969 "js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_start_pos + 1) in
# 297 "js_lexer.mll"
                  ( Buffer.add_char buf '\\';
                    Buffer.add_char buf x;
                    regexp buf lexbuf )
# 975 "js_lexer.ml"

  | 1 ->
# 300 "js_lexer.mll"
        ( Buffer.add_char buf '/'; regexp_maybe_ident buf lexbuf )
# 980 "js_lexer.ml"

  | 2 ->
# 301 "js_lexer.mll"
        ( Buffer.add_char buf '['; regexp_class buf lexbuf )
# 985 "js_lexer.ml"

  | 3 ->
let
# 302 "js_lexer.mll"
          x
# 991 "js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 302 "js_lexer.mll"
                   ( Buffer.add_char buf x; regexp buf lexbuf )
# 995 "js_lexer.ml"

  | 4 ->
# 303 "js_lexer.mll"
        ( Format.eprintf "LEXER: WIERD end of file in regexp@."; ())
# 1000 "js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; 
      __ocaml_lex_regexp_rec buf lexbuf __ocaml_lex_state

and regexp_class buf lexbuf =
    __ocaml_lex_regexp_class_rec buf lexbuf 92
and __ocaml_lex_regexp_class_rec buf lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 306 "js_lexer.mll"
        ( Buffer.add_char buf ']';
             regexp buf lexbuf )
# 1013 "js_lexer.ml"

  | 1 ->
let
# 308 "js_lexer.mll"
               x
# 1019 "js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_start_pos + 1) in
# 308 "js_lexer.mll"
                  ( Buffer.add_char buf '\\';
                    Buffer.add_char buf x;
                    regexp_class buf lexbuf )
# 1025 "js_lexer.ml"

  | 2 ->
let
# 311 "js_lexer.mll"
          x
# 1031 "js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 311 "js_lexer.mll"
             ( Buffer.add_char buf x; regexp_class buf lexbuf )
# 1035 "js_lexer.ml"

  | 3 ->
# 312 "js_lexer.mll"
        ( Format.eprintf "LEXER: WIERD end of file in regexp_class@."; ())
# 1040 "js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; 
      __ocaml_lex_regexp_class_rec buf lexbuf __ocaml_lex_state

and regexp_maybe_ident buf lexbuf =
    __ocaml_lex_regexp_maybe_ident_rec buf lexbuf 98
and __ocaml_lex_regexp_maybe_ident_rec buf lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 315 "js_lexer.mll"
                      ( Buffer.add_string buf (tok lexbuf) )
# 1052 "js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; 
      __ocaml_lex_regexp_maybe_ident_rec buf lexbuf __ocaml_lex_state

and st_comment buf nl lexbuf =
    __ocaml_lex_st_comment_rec buf nl lexbuf 99
and __ocaml_lex_st_comment_rec buf nl lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 320 "js_lexer.mll"
         ( Buffer.add_string buf (tok lexbuf) )
# 1064 "js_lexer.ml"

  | 1 ->
# 323 "js_lexer.mll"
            ( Buffer.add_string buf (tok lexbuf);
              nl := true;
              st_comment buf nl lexbuf )
# 1071 "js_lexer.ml"

  | 2 ->
# 326 "js_lexer.mll"
                       ( Buffer.add_string buf (tok lexbuf);st_comment buf nl lexbuf )
# 1076 "js_lexer.ml"

  | 3 ->
# 327 "js_lexer.mll"
            ( Buffer.add_char buf '*';st_comment buf nl lexbuf )
# 1081 "js_lexer.ml"

  | 4 ->
# 329 "js_lexer.mll"
        ( Format.eprintf "LEXER: end of file in comment@."; Buffer.add_string buf "*/")
# 1086 "js_lexer.ml"

  | 5 ->
# 330 "js_lexer.mll"
       (
      let s = tok lexbuf in
      Format.eprintf "LEXER: unrecognised symbol in comment: %s@." s;
      Buffer.add_string buf s;
      st_comment buf nl lexbuf
    )
# 1096 "js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; 
      __ocaml_lex_st_comment_rec buf nl lexbuf __ocaml_lex_state

and pos lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 4 (-1) ;   __ocaml_lex_pos_rec lexbuf 106
and __ocaml_lex_pos_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 338 "js_lexer.mll"
                                    line
# 1109 "js_lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1)
and
# 338 "js_lexer.mll"
                                                                     quote
# 1114 "js_lexer.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_curr_pos + -1) in
# 338 "js_lexer.mll"
                                                                            (
      let buf = Buffer.create 127 in
      string_quote quote buf lexbuf;
      Buffer.contents buf, int_of_string line )
# 1121 "js_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; 
      __ocaml_lex_pos_rec lexbuf __ocaml_lex_state

;;

