open Ppxlib

(** [compare_type ty] is [ty -> ty -> int] *)
val compare_type : loc:Location.t -> core_type -> core_type

(** [compare_core_type ty] is an expression of type [ty -> ty -> int] *)
val compare_core_type : core_type -> expression

(** [equal_type ty] is [ty -> ty -> bool] *)
val equal_type : loc:Location.t -> core_type -> core_type

(** [equal_core_type ty] is an expression of type [ty -> ty -> bool], using the comparison
    function generated by [compare_core_type] *)
val equal_core_type : core_type -> expression

val str_attributes : Attribute.packed list

val str_type_decl
  :  loc:Location.t
  -> path:string
  -> rec_flag * type_declaration list
  -> structure

val sig_type_decl
  :  loc:Location.t
  -> path:string
  -> rec_flag * type_declaration list
  -> signature

module Attrs : sig
  val ignore : (label_declaration, unit) Attribute.t
end
