/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Port;
import sun.nio.ch.ThreadPool;

final class AixPollPort
extends Port {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int SIZEOF_POLLFD;
    private static final int OFFSETOF_EVENTS;
    private static final int OFFSETOF_REVENTS;
    private static final int OFFSETOF_FD;
    private static final int PS_ADD = 0;
    private static final int PS_MOD = 1;
    private static final int PS_DELETE = 2;
    private static final int MAX_POLL_EVENTS = 512;
    private final int pollset;
    private boolean closed;
    private final int[] sp;
    private final int[] ctlSp;
    private final AtomicInteger wakeupCount = new AtomicInteger();
    private final long address;
    private final ArrayBlockingQueue<Event> queue;
    private final Event NEED_TO_POLL = new Event(null, 0);
    private final Event EXECUTE_TASK_OR_SHUTDOWN = new Event(null, 0);
    private final HashSet<ControlEvent> controlQueue = new HashSet();
    private final ReentrantLock controlLock = new ReentrantLock();

    AixPollPort(AsynchronousChannelProvider asynchronousChannelProvider, ThreadPool threadPool) throws IOException {
        super(asynchronousChannelProvider, threadPool);
        this.pollset = AixPollPort.pollsetCreate();
        int[] nArray = new int[2];
        try {
            AixPollPort.socketpair(nArray);
            AixPollPort.pollsetCtl(this.pollset, 0, nArray[0], 1);
        }
        catch (IOException iOException) {
            AixPollPort.pollsetDestroy(this.pollset);
            throw iOException;
        }
        this.sp = nArray;
        nArray = new int[2];
        try {
            AixPollPort.socketpair(nArray);
            AixPollPort.pollsetCtl(this.pollset, 0, nArray[0], 1);
        }
        catch (IOException iOException) {
            AixPollPort.pollsetDestroy(this.pollset);
            throw iOException;
        }
        this.ctlSp = nArray;
        this.address = AixPollPort.allocatePollArray(512);
        this.queue = new ArrayBlockingQueue(512);
        this.queue.offer(this.NEED_TO_POLL);
    }

    AixPollPort start() {
        this.startThreads(new EventHandlerTask());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implClose() {
        AixPollPort aixPollPort = this;
        synchronized (aixPollPort) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        AixPollPort.freePollArray(this.address);
        AixPollPort.close0(this.sp[0]);
        AixPollPort.close0(this.sp[1]);
        AixPollPort.close0(this.ctlSp[0]);
        AixPollPort.close0(this.ctlSp[1]);
        AixPollPort.pollsetDestroy(this.pollset);
    }

    private void wakeup() {
        if (this.wakeupCount.incrementAndGet() == 1) {
            try {
                AixPollPort.interrupt(this.sp[1]);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeOnHandlerTask(Runnable runnable) {
        AixPollPort aixPollPort = this;
        synchronized (aixPollPort) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            this.offerTask(runnable);
            this.wakeup();
        }
    }

    @Override
    void shutdownHandlerTasks() {
        int n = this.threadCount();
        if (n == 0) {
            this.implClose();
        } else {
            while (n-- > 0) {
                this.wakeup();
            }
        }
    }

    @Override
    void startPoll(int n, int n2) {
        this.queueControlEvent(new ControlEvent(n, n2, false));
    }

    @Override
    void unregisterImpl(int n) {
        this.queueControlEvent(new ControlEvent(n, 0, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueControlEvent(ControlEvent controlEvent) {
        HashSet<ControlEvent> hashSet = this.controlQueue;
        synchronized (hashSet) {
            this.controlQueue.add(controlEvent);
            try {
                AixPollPort.interrupt(this.ctlSp[1]);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
            do {
                if (this.controlLock.tryLock()) {
                    try {
                        this.processControlQueue();
                    }
                    finally {
                        this.controlLock.unlock();
                    }
                } else {
                    try {
                        this.controlQueue.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } while (this.controlQueue.contains(controlEvent));
        }
        if (controlEvent.error() != 0) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processControlQueue() {
        HashSet<ControlEvent> hashSet = this.controlQueue;
        synchronized (hashSet) {
            Iterator<ControlEvent> iterator = this.controlQueue.iterator();
            while (iterator.hasNext()) {
                ControlEvent controlEvent = iterator.next();
                AixPollPort.pollsetCtl(this.pollset, 2, controlEvent.fd(), 0);
                if (!controlEvent.removeOnly()) {
                    controlEvent.setError(AixPollPort.pollsetCtl(this.pollset, 1, controlEvent.fd(), controlEvent.events()));
                }
                iterator.remove();
            }
            this.controlQueue.notifyAll();
        }
    }

    private static long allocatePollArray(int n) {
        return unsafe.allocateMemory(n * SIZEOF_POLLFD);
    }

    private static void freePollArray(long l) {
        unsafe.freeMemory(l);
    }

    private static long getEvent(long l, int n) {
        return l + (long)(SIZEOF_POLLFD * n);
    }

    private static int getDescriptor(long l) {
        return unsafe.getInt(l + (long)OFFSETOF_FD);
    }

    private static int getEvents(long l) {
        return unsafe.getChar(l + (long)OFFSETOF_EVENTS);
    }

    private static int getRevents(long l) {
        return unsafe.getChar(l + (long)OFFSETOF_REVENTS);
    }

    private static native void init();

    private static native int eventSize();

    private static native int eventsOffset();

    private static native int reventsOffset();

    private static native int fdOffset();

    private static native int pollsetCreate() throws IOException;

    private static native int pollsetCtl(int var0, int var1, int var2, int var3);

    private static native int pollsetPoll(int var0, long var1, int var3) throws IOException;

    private static native void pollsetDestroy(int var0);

    private static native void socketpair(int[] var0) throws IOException;

    private static native void interrupt(int var0) throws IOException;

    private static native void drain1(int var0) throws IOException;

    private static native void close0(int var0);

    static /* synthetic */ void access$1800(AixPollPort aixPollPort) {
        aixPollPort.implClose();
    }

    static {
        IOUtil.load();
        AixPollPort.init();
        SIZEOF_POLLFD = AixPollPort.eventSize();
        OFFSETOF_EVENTS = AixPollPort.eventsOffset();
        OFFSETOF_REVENTS = AixPollPort.reventsOffset();
        OFFSETOF_FD = AixPollPort.fdOffset();
    }

    private class EventHandlerTask
    implements Runnable {
        private EventHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Event poll() throws IOException {
            try {
                block15: while (true) {
                    int n;
                    AixPollPort.this.controlLock.lock();
                    try {
                        n = AixPollPort.pollsetPoll(AixPollPort.this.pollset, AixPollPort.this.address, 512);
                    }
                    finally {
                        AixPollPort.this.controlLock.unlock();
                    }
                    AixPollPort.this.fdToChannelLock.readLock().lock();
                    try {
                        while (true) {
                            Object object;
                            if (n-- <= 0) continue block15;
                            long l = AixPollPort.getEvent(AixPollPort.this.address, n);
                            int n2 = AixPollPort.getDescriptor(l);
                            AixPollPort.pollsetCtl(AixPollPort.this.pollset, 2, n2, 0);
                            if (n2 == AixPollPort.this.sp[0]) {
                                if (AixPollPort.this.wakeupCount.decrementAndGet() == 0) {
                                    AixPollPort.drain1(AixPollPort.this.sp[0]);
                                }
                                AixPollPort.pollsetCtl(AixPollPort.this.pollset, 0, AixPollPort.this.sp[0], 1);
                                if (n <= 0) {
                                    object = AixPollPort.this.EXECUTE_TASK_OR_SHUTDOWN;
                                    return object;
                                }
                                AixPollPort.this.queue.offer(AixPollPort.this.EXECUTE_TASK_OR_SHUTDOWN);
                                continue;
                            }
                            if (n2 == AixPollPort.this.ctlSp[0]) {
                                object = AixPollPort.this.controlQueue;
                                synchronized (object) {
                                    AixPollPort.drain1(AixPollPort.this.ctlSp[0]);
                                    AixPollPort.pollsetCtl(AixPollPort.this.pollset, 0, AixPollPort.this.ctlSp[0], 1);
                                    AixPollPort.this.processControlQueue();
                                    continue;
                                }
                            }
                            object = (Port.PollableChannel)AixPollPort.this.fdToChannel.get(n2);
                            if (object == null) continue;
                            int n3 = AixPollPort.getRevents(l);
                            Event event = new Event((Port.PollableChannel)object, n3);
                            if (n <= 0) {
                                Event event2 = event;
                                return event2;
                            }
                            AixPollPort.this.queue.offer(event);
                        }
                    }
                    finally {
                        AixPollPort.this.fdToChannelLock.readLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            finally {
                AixPollPort.this.queue.offer(AixPollPort.this.NEED_TO_POLL);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class ControlEvent {
        final int fd;
        final int events;
        final boolean removeOnly;
        int error = 0;

        ControlEvent(int n, int n2, boolean bl) {
            this.fd = n;
            this.events = n2;
            this.removeOnly = bl;
        }

        int fd() {
            return this.fd;
        }

        int events() {
            return this.events;
        }

        boolean removeOnly() {
            return this.removeOnly;
        }

        int error() {
            return this.error;
        }

        void setError(int n) {
            this.error = n;
        }
    }

    static class Event {
        final Port.PollableChannel channel;
        final int events;

        Event(Port.PollableChannel pollableChannel, int n) {
            this.channel = pollableChannel;
            this.events = n;
        }

        Port.PollableChannel channel() {
            return this.channel;
        }

        int events() {
            return this.events;
        }
    }
}

