/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.LinkedList;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelChImpl;
import sun.security.action.GetPropertyAction;

class KQueueArrayWrapper {
    static final short POLLIN = 1;
    static final short POLLOUT = 4;
    static short EVFILT_READ;
    static short EVFILT_WRITE;
    static short SIZEOF_KEVENT;
    static short FD_OFFSET;
    static short FILTER_OFFSET;
    static final int NUM_KEVENTS = 128;
    static boolean is64bit;
    private AllocatedNativeObject keventArray = null;
    private long keventArrayAddress;
    private int kq = -1;
    private int outgoingInterruptFD;
    private int incomingInterruptFD;
    private LinkedList<Update> updateList = new LinkedList();

    KQueueArrayWrapper() {
        int n = SIZEOF_KEVENT * 128;
        this.keventArray = new AllocatedNativeObject(n, true);
        this.keventArrayAddress = this.keventArray.address();
        this.kq = this.init();
    }

    void initInterrupt(int n, int n2) {
        this.outgoingInterruptFD = n2;
        this.incomingInterruptFD = n;
        this.register0(this.kq, n, 1, 0);
    }

    int getReventOps(int n) {
        int n2 = 0;
        int n3 = SIZEOF_KEVENT * n + FILTER_OFFSET;
        short s = this.keventArray.getShort(n3);
        if (s == EVFILT_READ) {
            n2 |= 1;
        } else if (s == EVFILT_WRITE) {
            n2 |= 4;
        }
        return n2;
    }

    int getDescriptor(int n) {
        int n2 = SIZEOF_KEVENT * n + FD_OFFSET;
        if (is64bit) {
            long l = this.keventArray.getLong(n2);
            assert (l <= Integer.MAX_VALUE);
            return (int)l;
        }
        return this.keventArray.getInt(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(SelChImpl selChImpl, int n) {
        LinkedList<Update> linkedList = this.updateList;
        synchronized (linkedList) {
            this.updateList.add(new Update(selChImpl, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(SelChImpl selChImpl) {
        LinkedList<Update> linkedList = this.updateList;
        synchronized (linkedList) {
            Iterator iterator = this.updateList.iterator();
            while (iterator.hasNext()) {
                if (((Update)iterator.next()).channel != selChImpl) continue;
                iterator.remove();
            }
            this.register0(this.kq, selChImpl.getFDVal(), 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegistrations() {
        LinkedList<Update> linkedList = this.updateList;
        synchronized (linkedList) {
            Update update = null;
            while ((update = this.updateList.poll()) != null) {
                SelChImpl selChImpl = update.channel;
                if (!selChImpl.isOpen()) continue;
                this.register0(this.kq, selChImpl.getFDVal(), update.events & 1, update.events & 4);
            }
        }
    }

    void close() throws IOException {
        if (this.keventArray != null) {
            this.keventArray.free();
            this.keventArray = null;
        }
        if (this.kq >= 0) {
            FileDispatcherImpl.closeIntFD(this.kq);
            this.kq = -1;
        }
    }

    int poll(long l) {
        this.updateRegistrations();
        int n = this.kevent0(this.kq, this.keventArrayAddress, 128, l);
        return n;
    }

    void interrupt() {
        KQueueArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    private native int init();

    private static native void initStructSizes();

    private native void register0(int var1, int var2, int var3, int var4);

    private native int kevent0(int var1, long var2, int var4, long var5);

    private static native void interrupt(int var0);

    static {
        is64bit = false;
        IOUtil.load();
        KQueueArrayWrapper.initStructSizes();
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.arch.data.model"));
        is64bit = string.equals("64");
    }

    private static class Update {
        SelChImpl channel;
        int events;

        Update(SelChImpl selChImpl, int n) {
            this.channel = selChImpl;
            this.events = n;
        }
    }
}

