/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.nio.ch.IOUtil;
import sun.nio.ch.KQueue;
import sun.nio.ch.Port;
import sun.nio.ch.ThreadPool;

final class KQueuePort
extends Port {
    private static final int MAX_KEVENTS_TO_POLL = 512;
    private final int kqfd;
    private boolean closed;
    private final int[] sp;
    private final AtomicInteger wakeupCount = new AtomicInteger();
    private final long address;
    private final ArrayBlockingQueue<Event> queue;
    private final Event NEED_TO_POLL = new Event(null, 0);
    private final Event EXECUTE_TASK_OR_SHUTDOWN = new Event(null, 0);

    KQueuePort(AsynchronousChannelProvider asynchronousChannelProvider, ThreadPool threadPool) throws IOException {
        super(asynchronousChannelProvider, threadPool);
        this.kqfd = KQueue.kqueue();
        int[] nArray = new int[2];
        try {
            KQueuePort.socketpair(nArray);
            KQueue.keventRegister(this.kqfd, nArray[0], -1, 1);
        }
        catch (IOException iOException) {
            KQueuePort.close0(this.kqfd);
            throw iOException;
        }
        this.sp = nArray;
        this.address = KQueue.allocatePollArray(512);
        this.queue = new ArrayBlockingQueue(512);
        this.queue.offer(this.NEED_TO_POLL);
    }

    KQueuePort start() {
        this.startThreads(new EventHandlerTask());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implClose() {
        KQueuePort kQueuePort = this;
        synchronized (kQueuePort) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        KQueue.freePollArray(this.address);
        KQueuePort.close0(this.sp[0]);
        KQueuePort.close0(this.sp[1]);
        KQueuePort.close0(this.kqfd);
    }

    private void wakeup() {
        if (this.wakeupCount.incrementAndGet() == 1) {
            try {
                KQueuePort.interrupt(this.sp[1]);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeOnHandlerTask(Runnable runnable) {
        KQueuePort kQueuePort = this;
        synchronized (kQueuePort) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            this.offerTask(runnable);
            this.wakeup();
        }
    }

    @Override
    void shutdownHandlerTasks() {
        int n = this.threadCount();
        if (n == 0) {
            this.implClose();
        } else {
            while (n-- > 0) {
                this.wakeup();
            }
        }
    }

    @Override
    void startPoll(int n, int n2) {
        int n3 = 0;
        int n4 = 17;
        if ((n2 & 1) > 0) {
            n3 = KQueue.keventRegister(this.kqfd, n, -1, n4);
        }
        if (n3 == 0 && (n2 & 4) > 0) {
            n3 = KQueue.keventRegister(this.kqfd, n, -2, n4);
        }
        if (n3 != 0) {
            throw new InternalError("kevent failed: " + n3);
        }
    }

    private static native void socketpair(int[] var0) throws IOException;

    private static native void interrupt(int var0) throws IOException;

    private static native void drain1(int var0) throws IOException;

    private static native void close0(int var0);

    static /* synthetic */ void access$900(KQueuePort kQueuePort) {
        kQueuePort.implClose();
    }

    static {
        IOUtil.load();
    }

    private class EventHandlerTask
    implements Runnable {
        private EventHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Event poll() throws IOException {
            try {
                block10: while (true) {
                    int n = KQueue.keventPoll(KQueuePort.this.kqfd, KQueuePort.this.address, 512);
                    KQueuePort.this.fdToChannelLock.readLock().lock();
                    try {
                        while (true) {
                            Object object;
                            if (n-- <= 0) continue block10;
                            long l = KQueue.getEvent(KQueuePort.this.address, n);
                            int n2 = KQueue.getDescriptor(l);
                            if (n2 == KQueuePort.this.sp[0]) {
                                if (KQueuePort.this.wakeupCount.decrementAndGet() == 0) {
                                    KQueuePort.drain1(KQueuePort.this.sp[0]);
                                }
                                if (n <= 0) {
                                    object = KQueuePort.this.EXECUTE_TASK_OR_SHUTDOWN;
                                    return object;
                                }
                                KQueuePort.this.queue.offer(KQueuePort.this.EXECUTE_TASK_OR_SHUTDOWN);
                                continue;
                            }
                            object = (Port.PollableChannel)KQueuePort.this.fdToChannel.get(n2);
                            if (object == null) continue;
                            int n3 = KQueue.getFilter(l);
                            int n4 = 0;
                            if (n3 == -1) {
                                n4 = 1;
                            } else if (n3 == -2) {
                                n4 = 4;
                            }
                            Event event = new Event((Port.PollableChannel)object, n4);
                            if (n <= 0) {
                                Event event2 = event;
                                return event2;
                            }
                            KQueuePort.this.queue.offer(event);
                        }
                    }
                    finally {
                        KQueuePort.this.fdToChannelLock.readLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            finally {
                KQueuePort.this.queue.offer(KQueuePort.this.NEED_TO_POLL);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class Event {
        final Port.PollableChannel channel;
        final int events;

        Event(Port.PollableChannel pollableChannel, int n) {
            this.channel = pollableChannel;
            this.events = n;
        }

        Port.PollableChannel channel() {
            return this.channel;
        }

        int events() {
            return this.events;
        }
    }
}

