/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Objects;
import sun.reflect.BootstrapConstructorAccessorImpl;
import sun.reflect.ConstructorAccessor;
import sun.reflect.ConstructorAccessorImpl;
import sun.reflect.DelegatingConstructorAccessorImpl;
import sun.reflect.DelegatingMethodAccessorImpl;
import sun.reflect.FieldAccessor;
import sun.reflect.InstantiationExceptionConstructorAccessorImpl;
import sun.reflect.LangReflectAccess;
import sun.reflect.MethodAccessor;
import sun.reflect.MethodAccessorGenerator;
import sun.reflect.NativeConstructorAccessorImpl;
import sun.reflect.NativeMethodAccessorImpl;
import sun.reflect.Reflection;
import sun.reflect.SerializationConstructorAccessorImpl;
import sun.reflect.UnsafeFieldAccessorFactory;

public class ReflectionFactory {
    private static boolean initted = false;
    private static final Permission reflectionFactoryAccessPerm = new RuntimePermission("reflectionFactoryAccess");
    private static final ReflectionFactory soleInstance = new ReflectionFactory();
    private static volatile LangReflectAccess langReflectAccess;
    private static volatile Method hasStaticInitializerMethod;
    private static boolean noInflation;
    private static int inflationThreshold;

    private ReflectionFactory() {
    }

    public static ReflectionFactory getReflectionFactory() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(reflectionFactoryAccessPerm);
        }
        return soleInstance;
    }

    public void setLangReflectAccess(LangReflectAccess langReflectAccess) {
        ReflectionFactory.langReflectAccess = langReflectAccess;
    }

    public FieldAccessor newFieldAccessor(Field field, boolean bl) {
        ReflectionFactory.checkInitted();
        return UnsafeFieldAccessorFactory.newFieldAccessor(field, bl);
    }

    public MethodAccessor newMethodAccessor(Method method) {
        ReflectionFactory.checkInitted();
        if (noInflation) {
            return new MethodAccessorGenerator().generateMethod(method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getReturnType(), method.getExceptionTypes(), method.getModifiers());
        }
        NativeMethodAccessorImpl nativeMethodAccessorImpl = new NativeMethodAccessorImpl(method);
        DelegatingMethodAccessorImpl delegatingMethodAccessorImpl = new DelegatingMethodAccessorImpl(nativeMethodAccessorImpl);
        nativeMethodAccessorImpl.setParent(delegatingMethodAccessorImpl);
        return delegatingMethodAccessorImpl;
    }

    public ConstructorAccessor newConstructorAccessor(Constructor constructor) {
        ReflectionFactory.checkInitted();
        Class clazz = constructor.getDeclaringClass();
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return new InstantiationExceptionConstructorAccessorImpl(null);
        }
        if (clazz == Class.class) {
            return new InstantiationExceptionConstructorAccessorImpl("Can not instantiate java.lang.Class");
        }
        if (Reflection.isSubclassOf(clazz, ConstructorAccessorImpl.class)) {
            return new BootstrapConstructorAccessorImpl(constructor);
        }
        if (noInflation) {
            return new MethodAccessorGenerator().generateConstructor(constructor.getDeclaringClass(), constructor.getParameterTypes(), constructor.getExceptionTypes(), constructor.getModifiers());
        }
        NativeConstructorAccessorImpl nativeConstructorAccessorImpl = new NativeConstructorAccessorImpl(constructor);
        DelegatingConstructorAccessorImpl delegatingConstructorAccessorImpl = new DelegatingConstructorAccessorImpl(nativeConstructorAccessorImpl);
        nativeConstructorAccessorImpl.setParent(delegatingConstructorAccessorImpl);
        return delegatingConstructorAccessorImpl;
    }

    public Field newField(Class<?> clazz, String string, Class<?> clazz2, int n, int n2, String string2, byte[] byArray) {
        return ReflectionFactory.langReflectAccess().newField(clazz, string, clazz2, n, n2, string2, byArray);
    }

    public Method newMethod(Class<?> clazz, String string, Class<?>[] classArray, Class<?> clazz2, Class<?>[] classArray2, int n, int n2, String string2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return ReflectionFactory.langReflectAccess().newMethod(clazz, string, classArray, clazz2, classArray2, n, n2, string2, byArray, byArray2, byArray3);
    }

    public Constructor newConstructor(Class<?> clazz, Class<?>[] classArray, Class<?>[] classArray2, int n, int n2, String string, byte[] byArray, byte[] byArray2) {
        return ReflectionFactory.langReflectAccess().newConstructor(clazz, classArray, classArray2, n, n2, string, byArray, byArray2);
    }

    public MethodAccessor getMethodAccessor(Method method) {
        return ReflectionFactory.langReflectAccess().getMethodAccessor(method);
    }

    public void setMethodAccessor(Method method, MethodAccessor methodAccessor) {
        ReflectionFactory.langReflectAccess().setMethodAccessor(method, methodAccessor);
    }

    public ConstructorAccessor getConstructorAccessor(Constructor constructor) {
        return ReflectionFactory.langReflectAccess().getConstructorAccessor(constructor);
    }

    public void setConstructorAccessor(Constructor constructor, ConstructorAccessor constructorAccessor) {
        ReflectionFactory.langReflectAccess().setConstructorAccessor(constructor, constructorAccessor);
    }

    public Method copyMethod(Method method) {
        return ReflectionFactory.langReflectAccess().copyMethod(method);
    }

    public Field copyField(Field field) {
        return ReflectionFactory.langReflectAccess().copyField(field);
    }

    public <T> Constructor<T> copyConstructor(Constructor<T> constructor) {
        return ReflectionFactory.langReflectAccess().copyConstructor(constructor);
    }

    public Constructor newConstructorForSerialization(Class<?> clazz, Constructor constructor) {
        if (constructor.getDeclaringClass() == clazz) {
            return constructor;
        }
        return this.generateConstructor(clazz, constructor);
    }

    public final Constructor<?> newConstructorForSerialization(Class<?> clazz) {
        Constructor<?> constructor;
        Class<?> clazz2 = clazz;
        while (Serializable.class.isAssignableFrom(clazz2)) {
            if ((clazz2 = clazz2.getSuperclass()) != null) continue;
            return null;
        }
        try {
            constructor = clazz2.getDeclaredConstructor(new Class[0]);
            int n = constructor.getModifiers();
            if ((n & 2) != 0 || (n & 5) == 0 && !ReflectionFactory.packageEquals(clazz, clazz2)) {
                return null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        return this.generateConstructor(clazz, constructor);
    }

    private final Constructor<?> generateConstructor(Class<?> clazz, Constructor<?> constructor) {
        SerializationConstructorAccessorImpl serializationConstructorAccessorImpl = new MethodAccessorGenerator().generateSerializationConstructor(clazz, constructor.getParameterTypes(), constructor.getExceptionTypes(), constructor.getModifiers(), constructor.getDeclaringClass());
        Constructor constructor2 = this.newConstructor(constructor.getDeclaringClass(), constructor.getParameterTypes(), constructor.getExceptionTypes(), constructor.getModifiers(), ReflectionFactory.langReflectAccess().getConstructorSlot(constructor), ReflectionFactory.langReflectAccess().getConstructorSignature(constructor), ReflectionFactory.langReflectAccess().getConstructorAnnotations(constructor), ReflectionFactory.langReflectAccess().getConstructorParameterAnnotations(constructor));
        this.setConstructorAccessor(constructor2, serializationConstructorAccessorImpl);
        constructor2.setAccessible(true);
        return constructor2;
    }

    public final Constructor<?> newConstructorForExternalization(Class<?> clazz) {
        if (!Externalizable.class.isAssignableFrom(clazz)) {
            return null;
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public final MethodHandle readObjectForSerialization(Class<?> clazz) {
        return this.findReadWriteObjectForSerialization(clazz, "readObject", ObjectInputStream.class);
    }

    public final MethodHandle readObjectNoDataForSerialization(Class<?> clazz) {
        return this.findReadWriteObjectForSerialization(clazz, "readObjectNoData", ObjectInputStream.class);
    }

    public final MethodHandle writeObjectForSerialization(Class<?> clazz) {
        return this.findReadWriteObjectForSerialization(clazz, "writeObject", ObjectOutputStream.class);
    }

    private final MethodHandle findReadWriteObjectForSerialization(Class<?> clazz, String string, Class<?> clazz2) {
        if (!Serializable.class.isAssignableFrom(clazz)) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(string, clazz2);
            int n = method.getModifiers();
            if (method.getReturnType() != Void.TYPE || Modifier.isStatic(n) || !Modifier.isPrivate(n)) {
                return null;
            }
            method.setAccessible(true);
            return MethodHandles.lookup().unreflect(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (InternalError)new InternalError("Error").initCause(illegalAccessException);
        }
    }

    public final MethodHandle readResolveForSerialization(Class<?> clazz) {
        return this.getReplaceResolveForSerialization(clazz, "readResolve");
    }

    public final MethodHandle writeReplaceForSerialization(Class<?> clazz) {
        return this.getReplaceResolveForSerialization(clazz, "writeReplace");
    }

    private MethodHandle getReplaceResolveForSerialization(Class<?> clazz, String string) {
        if (!Serializable.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            try {
                Method method = clazz2.getDeclaredMethod(string, new Class[0]);
                if (method.getReturnType() != Object.class) {
                    return null;
                }
                int n = method.getModifiers();
                if (Modifier.isStatic(n) | Modifier.isAbstract(n)) {
                    return null;
                }
                if (!(Modifier.isPublic(n) | Modifier.isProtected(n))) {
                    if (Modifier.isPrivate(n) && clazz != clazz2) {
                        return null;
                    }
                    if (!ReflectionFactory.packageEquals(clazz, clazz2)) {
                        return null;
                    }
                }
                try {
                    method.setAccessible(true);
                    return MethodHandles.lookup().unreflect(method);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw (InternalError)new InternalError("Error").initCause(illegalAccessException);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public final boolean hasStaticInitializerForSerialization(Class<?> clazz) {
        Method method = hasStaticInitializerMethod;
        if (method == null) {
            try {
                method = ObjectStreamClass.class.getDeclaredMethod("hasStaticInitializer", Class.class);
                method.setAccessible(true);
                hasStaticInitializerMethod = method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw (InternalError)new InternalError("No such method hasStaticInitializer on " + ObjectStreamClass.class).initCause(noSuchMethodException);
            }
        }
        try {
            return (Boolean)method.invoke(null, clazz);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw (InternalError)new InternalError("Exception invoking hasStaticInitializer").initCause(reflectiveOperationException);
        }
    }

    public final OptionalDataException newOptionalDataExceptionForSerialization(boolean bl) {
        try {
            Constructor constructor = OptionalDataException.class.getDeclaredConstructor(Boolean.TYPE);
            constructor.setAccessible(true);
            return (OptionalDataException)constructor.newInstance(bl);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw (InternalError)new InternalError("unable to create OptionalDataException").initCause(reflectiveOperationException);
        }
    }

    static int inflationThreshold() {
        return inflationThreshold;
    }

    private static void checkInitted() {
        if (initted) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.out == null) {
                    return null;
                }
                String string = System.getProperty("sun.reflect.noInflation");
                if (string != null && string.equals("true")) {
                    noInflation = true;
                }
                if ((string = System.getProperty("sun.reflect.inflationThreshold")) != null) {
                    try {
                        inflationThreshold = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw (RuntimeException)new RuntimeException("Unable to parse property sun.reflect.inflationThreshold").initCause(numberFormatException);
                    }
                }
                initted = true;
                return null;
            }
        });
    }

    private static LangReflectAccess langReflectAccess() {
        if (langReflectAccess == null) {
            Modifier.isPublic(1);
        }
        return langReflectAccess;
    }

    private static boolean packageEquals(Class<?> clazz, Class<?> clazz2) {
        return clazz.getClassLoader() == clazz2.getClassLoader() && Objects.equals(clazz.getPackage(), clazz2.getPackage());
    }

    static {
        noInflation = false;
        inflationThreshold = 15;
    }

    public static final class GetReflectionFactoryAction
    implements PrivilegedAction<ReflectionFactory> {
        @Override
        public ReflectionFactory run() {
            return ReflectionFactory.getReflectionFactory();
        }
    }
}

