/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import sun.misc.Unsafe;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PrincipalName
implements Cloneable {
    public static final int KRB_NT_UNKNOWN = 0;
    public static final int KRB_NT_PRINCIPAL = 1;
    public static final int KRB_NT_SRV_INST = 2;
    public static final int KRB_NT_SRV_HST = 3;
    public static final int KRB_NT_SRV_XHST = 4;
    public static final int KRB_NT_UID = 5;
    public static final String TGS_DEFAULT_SRV_NAME = "krbtgt";
    public static final int TGS_DEFAULT_NT = 2;
    public static final char NAME_COMPONENT_SEPARATOR = '/';
    public static final char NAME_REALM_SEPARATOR = '@';
    public static final char REALM_COMPONENT_SEPARATOR = '.';
    public static final String NAME_COMPONENT_SEPARATOR_STR = "/";
    public static final String NAME_REALM_SEPARATOR_STR = "@";
    public static final String REALM_COMPONENT_SEPARATOR_STR = ".";
    private final int nameType;
    private final String[] nameStrings;
    private final Realm nameRealm;
    private final boolean realmDeduced;
    private transient String salt = null;
    private static final long NAME_STRINGS_OFFSET;
    private static final Unsafe UNSAFE;

    public PrincipalName(int n, String[] stringArray, Realm realm) {
        if (realm == null) {
            throw new IllegalArgumentException("Null realm not allowed");
        }
        PrincipalName.validateNameStrings(stringArray);
        this.nameType = n;
        this.nameStrings = (String[])stringArray.clone();
        this.nameRealm = realm;
        this.realmDeduced = false;
    }

    public PrincipalName(String[] stringArray, String string) throws RealmException {
        this(0, stringArray, new Realm(string));
    }

    private static void validateNameStrings(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Null nameStrings not allowed");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Empty nameStrings not allowed");
        }
        for (String string : stringArray) {
            if (string == null) {
                throw new IllegalArgumentException("Null nameString not allowed");
            }
            if (!string.isEmpty()) continue;
            throw new IllegalArgumentException("Empty nameString not allowed");
        }
    }

    public Object clone() {
        try {
            PrincipalName principalName = (PrincipalName)super.clone();
            UNSAFE.putObject((Object)this, NAME_STRINGS_OFFSET, this.nameStrings.clone());
            return principalName;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)"Should never happen");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PrincipalName) {
            PrincipalName principalName = (PrincipalName)object;
            return this.nameRealm.equals(principalName.nameRealm) && Arrays.equals(this.nameStrings, principalName.nameStrings);
        }
        return false;
    }

    public PrincipalName(DerValue derValue, Realm realm) throws Asn1Exception, IOException {
        Vector<String> vector;
        if (realm == null) {
            throw new IllegalArgumentException("Null realm not allowed");
        }
        this.realmDeduced = false;
        this.nameRealm = realm;
        if (derValue == null) {
            throw new IllegalArgumentException("Null encoding not allowed");
        }
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        Object object = derValue2.getData().getBigInteger();
        this.nameType = ((BigInteger)object).intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) == 1) {
            object = derValue2.getData().getDerValue();
            if (((DerValue)object).getTag() != 48) {
                throw new Asn1Exception(906);
            }
            vector = new Vector<String>();
            while (((DerValue)object).getData().available() > 0) {
                DerValue derValue3 = ((DerValue)object).getData().getDerValue();
                String string = new KerberosString(derValue3).toString();
                vector.addElement(string);
            }
        } else {
            throw new Asn1Exception(906);
        }
        this.nameStrings = new String[vector.size()];
        vector.copyInto(this.nameStrings);
        PrincipalName.validateNameStrings(this.nameStrings);
    }

    public static PrincipalName parse(DerInputStream derInputStream, byte by, boolean bl, Realm realm) throws Asn1Exception, IOException, RealmException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (realm == null) {
            realm = Realm.getDefault();
        }
        return new PrincipalName(derValue2, realm);
    }

    private static String[] parseName(String string) {
        String string2;
        Vector<String> vector = new Vector<String>();
        String string3 = string;
        int n = 0;
        int n2 = 0;
        while (n < string3.length()) {
            if (string3.charAt(n) == '/') {
                if (n > 0 && string3.charAt(n - 1) == '\\') {
                    string3 = string3.substring(0, n - 1) + string3.substring(n, string3.length());
                    continue;
                }
                if (n2 <= n) {
                    string2 = string3.substring(n2, n);
                    vector.addElement(string2);
                }
                n2 = n + 1;
            } else if (string3.charAt(n) == '@') {
                if (n > 0 && string3.charAt(n - 1) == '\\') {
                    string3 = string3.substring(0, n - 1) + string3.substring(n, string3.length());
                    continue;
                }
                if (n2 < n) {
                    string2 = string3.substring(n2, n);
                    vector.addElement(string2);
                }
                n2 = n + 1;
                break;
            }
            ++n;
        }
        if (n == string3.length()) {
            string2 = string3.substring(n2, n);
            vector.addElement(string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public PrincipalName(String string, int n, String string2) throws RealmException {
        if (string == null) {
            throw new IllegalArgumentException("Null name not allowed");
        }
        String[] stringArray = PrincipalName.parseName(string);
        PrincipalName.validateNameStrings(stringArray);
        if (string2 == null) {
            string2 = Realm.parseRealmAtSeparator(string);
        }
        this.realmDeduced = string2 == null;
        switch (n) {
            case 3: {
                String string3;
                if (stringArray.length >= 2) {
                    string3 = stringArray[1];
                    try {
                        String string4 = InetAddress.getByName(string3).getCanonicalHostName();
                        if (string4.toLowerCase(Locale.ENGLISH).startsWith(string3.toLowerCase(Locale.ENGLISH) + REALM_COMPONENT_SEPARATOR_STR)) {
                            string3 = string4;
                        }
                    }
                    catch (SecurityException | UnknownHostException exception) {
                        // empty catch block
                    }
                    stringArray[1] = string3.toLowerCase(Locale.ENGLISH);
                }
                this.nameStrings = stringArray;
                this.nameType = n;
                if (string2 != null) {
                    this.nameRealm = new Realm(string2);
                    break;
                }
                string3 = PrincipalName.mapHostToRealm(stringArray[1]);
                if (string3 != null) {
                    this.nameRealm = new Realm(string3);
                    break;
                }
                this.nameRealm = Realm.getDefault();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                this.nameStrings = stringArray;
                this.nameType = n;
                if (string2 != null) {
                    this.nameRealm = new Realm(string2);
                    break;
                }
                this.nameRealm = Realm.getDefault();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal name type");
            }
        }
    }

    public PrincipalName(String string, int n) throws RealmException {
        this(string, n, (String)null);
    }

    public PrincipalName(String string) throws RealmException {
        this(string, 0);
    }

    public PrincipalName(String string, String string2) throws RealmException {
        this(string, 0, string2);
    }

    public static PrincipalName tgsService(String string, String string2) throws KrbException {
        return new PrincipalName(2, new String[]{TGS_DEFAULT_SRV_NAME, string}, new Realm(string2));
    }

    public String getRealmAsString() {
        return this.getRealmString();
    }

    public String getPrincipalNameAsString() {
        StringBuffer stringBuffer = new StringBuffer(this.nameStrings[0]);
        for (int i = 1; i < this.nameStrings.length; ++i) {
            stringBuffer.append(this.nameStrings[i]);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getName() {
        return this.toString();
    }

    public int getNameType() {
        return this.nameType;
    }

    public String[] getNameStrings() {
        return (String[])this.nameStrings.clone();
    }

    public byte[][] toByteArray() {
        byte[][] byArrayArray = new byte[this.nameStrings.length][];
        for (int i = 0; i < this.nameStrings.length; ++i) {
            byArrayArray[i] = new byte[this.nameStrings[i].length()];
            byArrayArray[i] = this.nameStrings[i].getBytes();
        }
        return byArrayArray;
    }

    public String getRealmString() {
        return this.nameRealm.toString();
    }

    public Realm getRealm() {
        return this.nameRealm;
    }

    public String getSalt() {
        if (this.salt == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.nameRealm.toString());
            for (int i = 0; i < this.nameStrings.length; ++i) {
                stringBuffer.append(this.nameStrings[i]);
            }
            return stringBuffer.toString();
        }
        return this.salt;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nameStrings.length; ++i) {
            if (i > 0) {
                stringBuffer.append(NAME_COMPONENT_SEPARATOR_STR);
            }
            stringBuffer.append(this.nameStrings[i]);
        }
        stringBuffer.append(NAME_REALM_SEPARATOR_STR);
        stringBuffer.append(this.nameRealm.toString());
        return stringBuffer.toString();
    }

    public String getNameString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nameStrings.length; ++i) {
            if (i > 0) {
                stringBuffer.append(NAME_COMPONENT_SEPARATOR_STR);
            }
            stringBuffer.append(this.nameStrings[i]);
        }
        return stringBuffer.toString();
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        BigInteger bigInteger = BigInteger.valueOf(this.nameType);
        derOutputStream2.putInteger(bigInteger);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        DerValue[] derValueArray = new DerValue[this.nameStrings.length];
        for (int i = 0; i < this.nameStrings.length; ++i) {
            derValueArray[i] = new KerberosString(this.nameStrings[i]).toDerValue();
        }
        derOutputStream2.putSequence(derValueArray);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public boolean match(PrincipalName principalName) {
        boolean bl = true;
        if (this.nameRealm != null && principalName.nameRealm != null && !this.nameRealm.toString().equalsIgnoreCase(principalName.nameRealm.toString())) {
            bl = false;
        }
        if (this.nameStrings.length != principalName.nameStrings.length) {
            bl = false;
        } else {
            for (int i = 0; i < this.nameStrings.length; ++i) {
                if (this.nameStrings[i].equalsIgnoreCase(principalName.nameStrings[i])) continue;
                bl = false;
            }
        }
        return bl;
    }

    public void writePrincipal(CCacheOutputStream cCacheOutputStream) throws IOException {
        cCacheOutputStream.write32(this.nameType);
        cCacheOutputStream.write32(this.nameStrings.length);
        byte[] byArray = null;
        byArray = this.nameRealm.toString().getBytes();
        cCacheOutputStream.write32(byArray.length);
        cCacheOutputStream.write(byArray, 0, byArray.length);
        byte[] byArray2 = null;
        for (int i = 0; i < this.nameStrings.length; ++i) {
            byArray2 = this.nameStrings[i].getBytes();
            cCacheOutputStream.write32(byArray2.length);
            cCacheOutputStream.write(byArray2, 0, byArray2.length);
        }
    }

    public String getInstanceComponent() {
        if (this.nameStrings != null && this.nameStrings.length >= 2) {
            return new String(this.nameStrings[1]);
        }
        return null;
    }

    static String mapHostToRealm(String string) {
        String string2 = null;
        try {
            String string3 = null;
            Config config = Config.getInstance();
            string2 = config.getDefault(string, "domain_realm");
            if (string2 != null) {
                return string2;
            }
            for (int i = 1; i < string.length() && (string.charAt(i) != '.' || i == string.length() - 1 || (string2 = config.getDefault(string3 = string.substring(i), "domain_realm")) == null && (string2 = config.getDefault(string3 = string.substring(i + 1), "domain_realm")) == null); ++i) {
            }
        }
        catch (KrbException krbException) {
            // empty catch block
        }
        return string2;
    }

    public boolean isRealmDeduced() {
        return this.realmDeduced;
    }

    static {
        try {
            Unsafe unsafe = Unsafe.getUnsafe();
            NAME_STRINGS_OFFSET = unsafe.objectFieldOffset(PrincipalName.class.getDeclaredField("nameStrings"));
            UNSAFE = unsafe;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
    }
}

