/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.TicketFlags;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KrbCredInfo {
    public EncryptionKey key;
    public PrincipalName pname;
    public TicketFlags flags;
    public KerberosTime authtime;
    public KerberosTime starttime;
    public KerberosTime endtime;
    public KerberosTime renewTill;
    public PrincipalName sname;
    public HostAddresses caddr;

    private KrbCredInfo() {
    }

    public KrbCredInfo(EncryptionKey encryptionKey, PrincipalName principalName, TicketFlags ticketFlags, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, PrincipalName principalName2, HostAddresses hostAddresses) {
        this.key = encryptionKey;
        this.pname = principalName;
        this.flags = ticketFlags;
        this.authtime = kerberosTime;
        this.starttime = kerberosTime2;
        this.endtime = kerberosTime3;
        this.renewTill = kerberosTime4;
        this.sname = principalName2;
        this.caddr = hostAddresses;
    }

    public KrbCredInfo(DerValue derValue) throws Asn1Exception, IOException, RealmException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.pname = null;
        this.flags = null;
        this.authtime = null;
        this.starttime = null;
        this.endtime = null;
        this.renewTill = null;
        this.sname = null;
        this.caddr = null;
        this.key = EncryptionKey.parse(derValue.getData(), (byte)0, false);
        Realm realm = null;
        Realm realm2 = null;
        if (derValue.getData().available() > 0) {
            realm = Realm.parse(derValue.getData(), (byte)1, true);
        }
        if (derValue.getData().available() > 0) {
            this.pname = PrincipalName.parse(derValue.getData(), (byte)2, true, realm);
        }
        if (derValue.getData().available() > 0) {
            this.flags = TicketFlags.parse(derValue.getData(), (byte)3, true);
        }
        if (derValue.getData().available() > 0) {
            this.authtime = KerberosTime.parse(derValue.getData(), (byte)4, true);
        }
        if (derValue.getData().available() > 0) {
            this.starttime = KerberosTime.parse(derValue.getData(), (byte)5, true);
        }
        if (derValue.getData().available() > 0) {
            this.endtime = KerberosTime.parse(derValue.getData(), (byte)6, true);
        }
        if (derValue.getData().available() > 0) {
            this.renewTill = KerberosTime.parse(derValue.getData(), (byte)7, true);
        }
        if (derValue.getData().available() > 0) {
            realm2 = Realm.parse(derValue.getData(), (byte)8, true);
        }
        if (derValue.getData().available() > 0) {
            this.sname = PrincipalName.parse(derValue.getData(), (byte)9, true, realm2);
        }
        if (derValue.getData().available() > 0) {
            this.caddr = HostAddresses.parse(derValue.getData(), (byte)10, true);
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        Vector<DerValue> vector = new Vector<DerValue>();
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)0), this.key.asn1Encode()));
        if (this.pname != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)1), this.pname.getRealm().asn1Encode()));
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)2), this.pname.asn1Encode()));
        }
        if (this.flags != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)3), this.flags.asn1Encode()));
        }
        if (this.authtime != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)4), this.authtime.asn1Encode()));
        }
        if (this.starttime != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)5), this.starttime.asn1Encode()));
        }
        if (this.endtime != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)6), this.endtime.asn1Encode()));
        }
        if (this.renewTill != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)7), this.renewTill.asn1Encode()));
        }
        if (this.sname != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)8), this.sname.getRealm().asn1Encode()));
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)9), this.sname.asn1Encode()));
        }
        if (this.caddr != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)10), this.caddr.asn1Encode()));
        }
        Object[] objectArray = new DerValue[vector.size()];
        vector.copyInto(objectArray);
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence((DerValue[])objectArray);
        return derOutputStream.toByteArray();
    }

    public Object clone() {
        KrbCredInfo krbCredInfo = new KrbCredInfo();
        krbCredInfo.key = (EncryptionKey)this.key.clone();
        if (this.pname != null) {
            krbCredInfo.pname = (PrincipalName)this.pname.clone();
        }
        if (this.flags != null) {
            krbCredInfo.flags = (TicketFlags)this.flags.clone();
        }
        if (this.authtime != null) {
            krbCredInfo.authtime = (KerberosTime)this.authtime.clone();
        }
        if (this.starttime != null) {
            krbCredInfo.starttime = (KerberosTime)this.starttime.clone();
        }
        if (this.endtime != null) {
            krbCredInfo.endtime = (KerberosTime)this.endtime.clone();
        }
        if (this.renewTill != null) {
            krbCredInfo.renewTill = (KerberosTime)this.renewTill.clone();
        }
        if (this.sname != null) {
            krbCredInfo.sname = (PrincipalName)this.sname.clone();
        }
        if (this.caddr != null) {
            krbCredInfo.caddr = (HostAddresses)this.caddr.clone();
        }
        return krbCredInfo;
    }
}

