/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ccache;

import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCRep;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;

public class Credentials {
    PrincipalName cname;
    PrincipalName sname;
    EncryptionKey key;
    KerberosTime authtime;
    KerberosTime starttime;
    KerberosTime endtime;
    KerberosTime renewTill;
    HostAddresses caddr;
    AuthorizationData authorizationData;
    public boolean isEncInSKey;
    TicketFlags flags;
    Ticket ticket;
    Ticket secondTicket;
    private boolean DEBUG = Krb5.DEBUG;

    public Credentials(PrincipalName principalName, PrincipalName principalName2, EncryptionKey encryptionKey, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, boolean bl, TicketFlags ticketFlags, HostAddresses hostAddresses, AuthorizationData authorizationData, Ticket ticket, Ticket ticket2) {
        this.cname = (PrincipalName)principalName.clone();
        this.sname = (PrincipalName)principalName2.clone();
        this.key = (EncryptionKey)encryptionKey.clone();
        this.authtime = (KerberosTime)kerberosTime.clone();
        if (kerberosTime2 != null) {
            this.starttime = (KerberosTime)kerberosTime2.clone();
        }
        this.endtime = (KerberosTime)kerberosTime3.clone();
        if (kerberosTime4 != null) {
            this.renewTill = (KerberosTime)kerberosTime4.clone();
        }
        if (hostAddresses != null) {
            this.caddr = (HostAddresses)hostAddresses.clone();
        }
        if (authorizationData != null) {
            this.authorizationData = (AuthorizationData)authorizationData.clone();
        }
        this.isEncInSKey = bl;
        this.flags = (TicketFlags)ticketFlags.clone();
        this.ticket = (Ticket)ticket.clone();
        if (ticket2 != null) {
            this.secondTicket = (Ticket)ticket2.clone();
        }
    }

    public Credentials(KDCRep kDCRep, Ticket ticket, AuthorizationData authorizationData, boolean bl) {
        if (kDCRep.encKDCRepPart == null) {
            return;
        }
        this.cname = (PrincipalName)kDCRep.cname.clone();
        this.ticket = (Ticket)kDCRep.ticket.clone();
        this.key = (EncryptionKey)kDCRep.encKDCRepPart.key.clone();
        this.flags = (TicketFlags)kDCRep.encKDCRepPart.flags.clone();
        this.authtime = (KerberosTime)kDCRep.encKDCRepPart.authtime.clone();
        if (kDCRep.encKDCRepPart.starttime != null) {
            this.starttime = (KerberosTime)kDCRep.encKDCRepPart.starttime.clone();
        }
        this.endtime = (KerberosTime)kDCRep.encKDCRepPart.endtime.clone();
        if (kDCRep.encKDCRepPart.renewTill != null) {
            this.renewTill = (KerberosTime)kDCRep.encKDCRepPart.renewTill.clone();
        }
        this.sname = (PrincipalName)kDCRep.encKDCRepPart.sname.clone();
        this.caddr = (HostAddresses)kDCRep.encKDCRepPart.caddr.clone();
        this.secondTicket = (Ticket)ticket.clone();
        this.authorizationData = (AuthorizationData)authorizationData.clone();
        this.isEncInSKey = bl;
    }

    public Credentials(KDCRep kDCRep) {
        this(kDCRep, null);
    }

    public Credentials(KDCRep kDCRep, Ticket ticket) {
        this.sname = (PrincipalName)kDCRep.encKDCRepPart.sname.clone();
        this.cname = (PrincipalName)kDCRep.cname.clone();
        this.key = (EncryptionKey)kDCRep.encKDCRepPart.key.clone();
        this.authtime = (KerberosTime)kDCRep.encKDCRepPart.authtime.clone();
        this.starttime = kDCRep.encKDCRepPart.starttime != null ? (KerberosTime)kDCRep.encKDCRepPart.starttime.clone() : null;
        this.endtime = (KerberosTime)kDCRep.encKDCRepPart.endtime.clone();
        this.renewTill = kDCRep.encKDCRepPart.renewTill != null ? (KerberosTime)kDCRep.encKDCRepPart.renewTill.clone() : null;
        this.flags = kDCRep.encKDCRepPart.flags;
        this.caddr = kDCRep.encKDCRepPart.caddr != null ? (HostAddresses)kDCRep.encKDCRepPart.caddr.clone() : null;
        this.ticket = (Ticket)kDCRep.ticket.clone();
        if (ticket != null) {
            this.secondTicket = (Ticket)ticket.clone();
            this.isEncInSKey = true;
        } else {
            this.secondTicket = null;
            this.isEncInSKey = false;
        }
    }

    public boolean isValid() {
        boolean bl = true;
        if (this.endtime.getTime() < System.currentTimeMillis()) {
            bl = false;
        } else if (this.starttime != null) {
            if (this.starttime.getTime() > System.currentTimeMillis()) {
                bl = false;
            }
        } else if (this.authtime.getTime() > System.currentTimeMillis()) {
            bl = false;
        }
        return bl;
    }

    public PrincipalName getServicePrincipal() throws RealmException {
        return this.sname;
    }

    public sun.security.krb5.Credentials setKrbCreds() {
        return new sun.security.krb5.Credentials(this.ticket, this.cname, this.sname, this.key, this.flags, this.authtime, this.starttime, this.endtime, this.renewTill, this.caddr);
    }

    public KerberosTime getAuthTime() {
        return this.authtime;
    }

    public KerberosTime getEndTime() {
        return this.endtime;
    }

    public TicketFlags getTicketFlags() {
        return this.flags;
    }

    public int getEType() {
        return this.key.getEType();
    }
}

