/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import sun.security.spec.DSAGenParameterSpec;

public class DSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private static final DSAGenParameterSpec DEFAULTS = new DSAGenParameterSpec(1024, 160, 160);
    private int valueL = -1;
    private int valueN = -1;
    private int seedLen = -1;
    private SecureRandom random;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n >= 512 && n <= 1024 && n % 64 == 0) {
            this.valueN = 160;
        } else if (n == 2048) {
            this.valueN = 224;
        } else {
            throw new InvalidParameterException("Prime size should be 512 - 1024, or 2048");
        }
        this.valueL = n;
        this.seedLen = this.valueN;
        this.random = secureRandom;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Invalid parameter");
        }
        DSAGenParameterSpec dSAGenParameterSpec = (DSAGenParameterSpec)algorithmParameterSpec;
        if (dSAGenParameterSpec.getPrimePLength() > 2048) {
            throw new InvalidParameterException("Prime size should be 512 - 1024, or 2048");
        }
        this.valueL = dSAGenParameterSpec.getPrimePLength();
        this.valueN = dSAGenParameterSpec.getSubprimeQLength();
        this.seedLen = dSAGenParameterSpec.getSeedLength();
        this.random = secureRandom;
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters algorithmParameters = null;
        try {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            if (this.valueL == -1) {
                try {
                    this.engineInit(DEFAULTS, this.random);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    // empty catch block
                }
            }
            BigInteger[] bigIntegerArray = DSAParameterGenerator.generatePandQ(this.random, this.valueL, this.valueN, this.seedLen);
            BigInteger bigInteger = bigIntegerArray[0];
            BigInteger bigInteger2 = bigIntegerArray[1];
            BigInteger bigInteger3 = DSAParameterGenerator.generateG(bigInteger, bigInteger2);
            DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(bigInteger, bigInteger2, bigInteger3);
            algorithmParameters = AlgorithmParameters.getInstance("DSA", "SUN");
            algorithmParameters.init(dSAParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.getMessage());
        }
        return algorithmParameters;
    }

    /*
     * Unable to fully structure code
     */
    private static BigInteger[] generatePandQ(SecureRandom var0, int var1_1, int var2_2, int var3_3) {
        var4_4 = null;
        if (var2_2 == 160) {
            var4_4 = "SHA";
        } else if (var2_2 == 224) {
            var4_4 = "SHA-224";
        } else if (var2_2 == 256) {
            var4_4 = "SHA-256";
        }
        var5_5 = null;
        try {
            var5_5 = MessageDigest.getInstance(var4_4);
        }
        catch (NoSuchAlgorithmException var6_6) {
            var6_6.printStackTrace();
        }
        var6_7 = var5_5.getDigestLength() * 8;
        var7_8 = (var1_1 - 1) / var6_7;
        var8_9 = (var1_1 - 1) % var6_7;
        var9_10 = new byte[var3_3 / 8];
        var10_11 = DSAParameterGenerator.TWO.pow(var3_3);
        var11_12 = 80;
        if (var1_1 == 2048) {
            var11_12 = 112;
        }
        var14_13 = null;
        block2: while (true) {
            var0.nextBytes(var9_10);
            var14_13 = new BigInteger(1, var9_10);
            var16_17 = new BigInteger(1, var5_5.digest(var9_10)).mod(DSAParameterGenerator.TWO.pow(var2_2 - 1));
            var13_15 = DSAParameterGenerator.TWO.pow(var2_2 - 1).add(var16_17).add(DSAParameterGenerator.ONE).subtract(var16_17.mod(DSAParameterGenerator.TWO));
            if (!var13_15.isProbablePrime(var11_12)) continue;
            var16_17 = DSAParameterGenerator.ONE;
            var15_16 = 0;
            while (true) {
                if (var15_16 < 4 * var1_1) ** break;
                continue block2;
                var17_18 = new BigInteger[var7_8 + 1];
                for (var18_20 = 0; var18_20 <= var7_8; ++var18_20) {
                    var19_21 = BigInteger.valueOf(var18_20);
                    var20_23 = var14_13.add(var16_17).add(var19_21).mod(var10_11);
                    var21_24 = var5_5.digest(DSAParameterGenerator.toByteArray(var20_23));
                    var17_18[var18_20] = new BigInteger(1, (byte[])var21_24);
                }
                var18_19 = var17_18[0];
                for (var19_22 = 1; var19_22 < var7_8; ++var19_22) {
                    var18_19 = var18_19.add(var17_18[var19_22].multiply(DSAParameterGenerator.TWO.pow(var19_22 * var6_7)));
                }
                var20_23 = (var18_19 = var18_19.add(var17_18[var7_8].mod(DSAParameterGenerator.TWO.pow(var8_9)).multiply(DSAParameterGenerator.TWO.pow(var7_8 * var6_7)))).add(var19_21 = DSAParameterGenerator.TWO.pow(var1_1 - 1));
                var12_14 = var20_23.subtract((var21_24 = (Object)var20_23.mod(var13_15.multiply(DSAParameterGenerator.TWO))).subtract(DSAParameterGenerator.ONE));
                if (var12_14.compareTo(var19_21) > -1 && var12_14.isProbablePrime(var11_12)) {
                    var22_25 = new BigInteger[]{var12_14, var13_15, var14_13, BigInteger.valueOf(var15_16)};
                    return var22_25;
                }
                var16_17 = var16_17.add(BigInteger.valueOf(var7_8)).add(DSAParameterGenerator.ONE);
                ++var15_16;
            }
            break;
        }
    }

    private static BigInteger generateG(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = ONE;
        BigInteger bigInteger4 = bigInteger.subtract(ONE).divide(bigInteger2);
        BigInteger bigInteger5 = ONE;
        while (bigInteger5.compareTo(TWO) < 0) {
            bigInteger5 = bigInteger3.modPow(bigInteger4, bigInteger);
            bigInteger3 = bigInteger3.add(ONE);
        }
        return bigInteger5;
    }

    private static byte[] toByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }
}

