/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.math.BigInteger;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import sun.security.util.AnchorCertificates;
import sun.security.util.CertConstraintParameters;
import sun.security.util.Debug;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.KeyUtil;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

public final class AlgorithmChecker
extends PKIXCertPathChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private final AlgorithmConstraints constraints;
    private final PublicKey trustedPubKey;
    private PublicKey prevPubKey;
    private static final Set<CryptoPrimitive> SIGNATURE_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    private static final Set<CryptoPrimitive> KU_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE, CryptoPrimitive.KEY_ENCAPSULATION, CryptoPrimitive.PUBLIC_KEY_ENCRYPTION, CryptoPrimitive.KEY_AGREEMENT));
    private static final DisabledAlgorithmConstraints certPathDefaultConstraints = new DisabledAlgorithmConstraints("jdk.certpath.disabledAlgorithms");
    private static final boolean publicCALimits = certPathDefaultConstraints.checkProperty("jdkCA");
    private boolean trustedMatch = false;

    public AlgorithmChecker(TrustAnchor trustAnchor) {
        this(trustAnchor, certPathDefaultConstraints);
    }

    public AlgorithmChecker(AlgorithmConstraints algorithmConstraints) {
        this.prevPubKey = null;
        this.trustedPubKey = null;
        this.constraints = algorithmConstraints;
    }

    public AlgorithmChecker(TrustAnchor trustAnchor, AlgorithmConstraints algorithmConstraints) {
        if (trustAnchor == null) {
            throw new IllegalArgumentException("The trust anchor cannot be null");
        }
        if (trustAnchor.getTrustedCert() != null) {
            this.trustedPubKey = trustAnchor.getTrustedCert().getPublicKey();
            this.trustedMatch = AlgorithmChecker.checkFingerprint(trustAnchor.getTrustedCert());
            if (this.trustedMatch && debug != null) {
                debug.println("trustedMatch = true");
            }
        } else {
            this.trustedPubKey = trustAnchor.getCAPublicKey();
        }
        this.prevPubKey = this.trustedPubKey;
        this.constraints = algorithmConstraints;
    }

    private static boolean checkFingerprint(X509Certificate x509Certificate) {
        if (!publicCALimits) {
            return false;
        }
        if (debug != null) {
            debug.println("AlgorithmChecker.contains: " + x509Certificate.getSigAlgName());
        }
        return AnchorCertificates.contains(x509Certificate);
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (!bl) {
            this.prevPubKey = this.trustedPubKey != null ? this.trustedPubKey : null;
        } else {
            throw new CertPathValidatorException("forward checking not supported");
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        AlgorithmId algorithmId;
        X509CertImpl x509CertImpl;
        if (!(certificate instanceof X509Certificate) || this.constraints == null) {
            return;
        }
        boolean[] blArray = ((X509Certificate)certificate).getKeyUsage();
        if (blArray != null && blArray.length < 9) {
            throw new CertPathValidatorException("incorrect KeyUsage extension", null, null, -1, PKIXReason.INVALID_KEY_USAGE);
        }
        Set<CryptoPrimitive> set = KU_PRIMITIVE_SET;
        if (blArray != null) {
            set = EnumSet.noneOf(CryptoPrimitive.class);
            if (blArray[0] || blArray[1] || blArray[5] || blArray[6]) {
                set.add(CryptoPrimitive.SIGNATURE);
            }
            if (blArray[2]) {
                set.add(CryptoPrimitive.KEY_ENCAPSULATION);
            }
            if (blArray[3]) {
                set.add(CryptoPrimitive.PUBLIC_KEY_ENCRYPTION);
            }
            if (blArray[4]) {
                set.add(CryptoPrimitive.KEY_AGREEMENT);
            }
            if (set.isEmpty()) {
                throw new CertPathValidatorException("incorrect KeyUsage extension bits", null, null, -1, PKIXReason.INVALID_KEY_USAGE);
            }
        }
        PublicKey publicKey = certificate.getPublicKey();
        if (this.constraints instanceof DisabledAlgorithmConstraints) {
            ((DisabledAlgorithmConstraints)this.constraints).permits(set, new CertConstraintParameters((X509Certificate)certificate, this.trustedMatch));
            if (this.prevPubKey == null) {
                this.prevPubKey = publicKey;
                return;
            }
        }
        try {
            x509CertImpl = X509CertImpl.toImpl((X509Certificate)certificate);
            algorithmId = (AlgorithmId)x509CertImpl.get("x509.algorithm");
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException(certificateException);
        }
        AlgorithmParameters algorithmParameters = algorithmId.getParameters();
        String string = x509CertImpl.getSigAlgName();
        if (!(this.constraints instanceof DisabledAlgorithmConstraints)) {
            if (!this.constraints.permits(SIGNATURE_PRIMITIVE_SET, string, algorithmParameters)) {
                throw new CertPathValidatorException("Algorithm constraints check failed on signature algorithm: " + string, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
            if (!this.constraints.permits(set, publicKey)) {
                throw new CertPathValidatorException("Algorithm constraints check failed on keysize: " + KeyUtil.getKeySize(publicKey), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
        if (this.prevPubKey != null) {
            if (!this.constraints.permits(SIGNATURE_PRIMITIVE_SET, string, this.prevPubKey, algorithmParameters)) {
                throw new CertPathValidatorException("Algorithm constraints check failed on signature algorithm: " + string, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
            if (publicKey instanceof DSAPublicKey && ((DSAPublicKey)publicKey).getParams() == null) {
                if (!(this.prevPubKey instanceof DSAPublicKey)) {
                    throw new CertPathValidatorException("Input key is not of a appropriate type for inheriting parameters");
                }
                DSAParams dSAParams = ((DSAPublicKey)this.prevPubKey).getParams();
                if (dSAParams == null) {
                    throw new CertPathValidatorException("Key parameters missing from public key.");
                }
                try {
                    BigInteger bigInteger = ((DSAPublicKey)publicKey).getY();
                    KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                    DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger, dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
                    publicKey = keyFactory.generatePublic(dSAPublicKeySpec);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new CertPathValidatorException("Unable to generate key with inherited parameters: " + generalSecurityException.getMessage(), generalSecurityException);
                }
            }
        }
        this.prevPubKey = publicKey;
    }

    void trySetTrustAnchor(TrustAnchor trustAnchor) {
        if (this.prevPubKey == null) {
            if (trustAnchor == null) {
                throw new IllegalArgumentException("The trust anchor cannot be null");
            }
            if (trustAnchor.getTrustedCert() != null) {
                this.prevPubKey = trustAnchor.getTrustedCert().getPublicKey();
                this.trustedMatch = AlgorithmChecker.checkFingerprint(trustAnchor.getTrustedCert());
                if (this.trustedMatch && debug != null) {
                    debug.println("trustedMatch = true");
                }
            } else {
                this.prevPubKey = trustAnchor.getCAPublicKey();
            }
        }
    }

    static void check(PublicKey publicKey, X509CRL x509CRL) throws CertPathValidatorException {
        X509CRLImpl x509CRLImpl = null;
        try {
            x509CRLImpl = X509CRLImpl.toImpl(x509CRL);
        }
        catch (CRLException cRLException) {
            throw new CertPathValidatorException(cRLException);
        }
        AlgorithmId algorithmId = x509CRLImpl.getSigAlgId();
        AlgorithmChecker.check(publicKey, algorithmId);
    }

    static void check(PublicKey publicKey, AlgorithmId algorithmId) throws CertPathValidatorException {
        AlgorithmParameters algorithmParameters;
        String string = algorithmId.getName();
        if (!certPathDefaultConstraints.permits(SIGNATURE_PRIMITIVE_SET, string, publicKey, algorithmParameters = algorithmId.getParameters())) {
            throw new CertPathValidatorException("Algorithm constraints check failed on signature algorithm: " + string + " is disabled", null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }
    }
}

