'''OpenGL extension ARB.arrays_of_arrays

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.arrays_of_arrays to provide a more 
Python-friendly API

Overview (from the spec)
	
	Multi-dimensional arrays are a frequently requested feature.  This extension
	removes the restriciton that arrays cannot be formed into arrays, allowing
	arrays of arrays to be declared.  Technically, removing this restriction is 
	all that is necessary to enable this feature, but it is worthwhile showing
	what the result of doing that looks like.
	
	The following will be true of arrays of arrays
	
	- They will first class objects.  (They know their size, can be passed by 
	  copy-in semantics to functions, etc.)
	
	- They will only be one-dimensional arrays of other first class objects.
	  (arrays are already first class objects).
	
	- The syntax
	
	    vec4 a[3][2];
	
	  Declares a one-dimensional array of size 3 of one-dimensional arrays of 
	  size 2 of vec4s.  Also, these syntaxes do the same thing:
	
	    vec4[2] a[3];
	    vec4[3][2] a;
	
	  or, looking at more dimensions, these are all the same
	
	    int a[1][2][3][4][5][6];
	
	    int[1][2][3][4][5][6] a;
	
	    int[4][5][6] a[1][2][3];
	
	  note this latter is equivalent to C, in meaning the same thing, if done as
	
	    typedef int int456[4][5][6];
	
	    int456 a[1][2][3];
	
	  that is, this GLSL proposal matches C behavior in this way.  The type needed for
	  both constructors and nameless parameters is:
	
	     int[1][2][3][4][5][6]
	
	- This type could be declared as a formal parameter in a function prototype as
	
	    void foo(vec4[3][2]);
	
	- Accessing is done as
	
	    a[x][y]  // x selects which array of size 2 is desired
	             // y selects which vec4 is desired
	
	    a[x]     // this results in a one-dimensional array, with all rights and
	             // priviledges implied
	
	- The .length() operator works as normal:
	
	    a.length()     // this is 3
	    a[x].length()  // this is 2
	
	- The constructor for the above is
	
	    vec4[3][2](vec4[2](vec4(0.0), vec4(1.0)),   
	               vec4[2](vec4(0.0), vec4(1.0)),   
	               vec4[2](vec4(0.0), vec4(1.0)))
	
	- Initializers for the above are
	
	    vec4 a[3][2] = vec4[3][2](vec4[2](vec4(0.0), vec4(1.0)),   
	                              vec4[2](vec4(0.0), vec4(1.0)),   
	                              vec4[2](vec4(0.0), vec4(1.0)));
	
	    // or
	
	    vec4 a[3][2] = {vec4[2](vec4(0.0), vec4(1.0)),   
	                    vec4[2](vec4(0.0), vec4(1.0)),   
	                    vec4[2](vec4(0.0), vec4(1.0))) };
	
	    // or 
	
	    vec4 a[3][2] = {{ vec4(0.0), vec4(1.0) },   
	                    { vec4(0.0), vec4(1.0) },   
	                    { vec4(0.0), vec4(1.0) }  };  // requires matching nesting of 
	                                                  // {} with object's hierarchy
	
	
	Note that all the above is naturally already specified in the core 
	specification.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/arrays_of_arrays.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.arrays_of_arrays import *
from OpenGL.raw.GL.ARB.arrays_of_arrays import _EXTENSION_NAME

def glInitArraysOfArraysARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
