'''OpenGL extension ARB.cl_event

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.cl_event to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows creating OpenGL sync objects linked to OpenCL
	event objects, potentially improving efficiency of sharing images
	and buffers between the two APIs. The companion cl_khr_gl_event
	OpenCL extension provides the complementary functionality of
	creating an OpenCL event object from an OpenGL fence sync object.
	That extension is located in the OpenCL API Registry.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/cl_event.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.cl_event import *
from OpenGL.raw.GL.ARB.cl_event import _EXTENSION_NAME

def glInitClEventARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
