'''OpenGL extension ARB.conditional_render_inverted

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.conditional_render_inverted to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds new modes to BeginConditionalRender which invert
	the condition used to determine whether to draw or not.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/conditional_render_inverted.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.conditional_render_inverted import *
from OpenGL.raw.GL.ARB.conditional_render_inverted import _EXTENSION_NAME

def glInitConditionalRenderInvertedARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
