'''OpenGL extension ARB.half_float_vertex

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.half_float_vertex to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension extends the usage of the half-precision (16-bit) floating-
	point quantities introduced in ARB_half_float_pixel for usage in specifying
	vertex array data.
	
	This extension allows applications to use half-precision floating point data
	when specifying vertices.  This can allow applications to reduce their
	memory footprint, as well as the memory bandwidth required for vertex data.
	
	This extension extends the existing vertex array commands to accept the new
	data type.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/half_float_vertex.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.half_float_vertex import *
from OpenGL.raw.GL.ARB.half_float_vertex import _EXTENSION_NAME

def glInitHalfFloatVertexARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
