'''OpenGL extension ATI.element_array

This module customises the behaviour of the 
OpenGL.raw.GL.ATI.element_array to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a mechanism for an application to create
	an array of index data for use in specifying geometric primitives.
	
	This extension is most useful when used in conjunction with the
	ATI_vertex_array_object extension. ATI_vertex_array_object
	provides an interface for storing vertex array data in persistent,
	hardware-addressable memory. In cases where large amounts of
	vertex data are in use, the index data used to construct
	primitives (typically as passed to the GL through DrawElements)
	can impose a significant bandwidth burden. ATI_element_array
	allows the application to specify independent arrays of elements,
	which can then be cached using ATI_vertex_array_object.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ATI/element_array.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ATI.element_array import *
from OpenGL.raw.GL.ATI.element_array import _EXTENSION_NAME

def glInitElementArrayATI():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glElementPointerATI.pointer size not checked against 'type'
glElementPointerATI=wrapper.wrapper(glElementPointerATI).setInputArraySize(
    'pointer', None
)
### END AUTOGENERATED SECTION
