'''OpenGL extension ATI.text_fragment_shader

This module customises the behaviour of the 
OpenGL.raw.GL.ATI.text_fragment_shader to provide a more 
Python-friendly API

Overview (from the spec)
	
	The ATI_fragment_shader extension exposes a powerful fragment
	processing model that provides a very general means of expressing
	fragment color blending and dependent texture address modification.
	The processing is termed a fragment shader or fragment program and 
	is specifed using a register-based model in which there are fixed 
	numbers of instructions, texture lookups, read/write registers, and 
	constants.
	
	ATI_fragment_shader provides a unified instruction set
	for operating on address or color data and eliminates the
	distinction between the two.  That extension provides all the
	interfaces necessary to fully expose this programmable fragment
	processor in GL.
	
	ATI_text_fragment_shader is a redefinition of the 
	ATI_fragment_shader functionality, using a slightly different 
	interface.  The intent of creating ATI_text_fragment_shader is to
	take a step towards treating fragment programs similar to other 
	programmable parts of the GL rendering pipeline, specifically 
	vertex programs. This new interface is intended to appear 
	similar to the ARB_vertex_program API, within the limits of the 
	feature set exposed by the original ATI_fragment_shader extension.
	
	The most significant differences between the two extensions are:
	
	(1) ATI_fragment_shader provides a procedural function call
	    interface to specify the fragment program, whereas
	    ATI_text_fragment_shader uses a textual string to specify
	    the program.  The fundamental syntax and constructs of the
	    program "language" remain the same.
	
	(2) The program object managment portions of the interface,
	    namely the routines used to create, bind, and delete program
	    objects and set program constants are managed
	    using the framework defined by ARB_vertex_program.
	
	(3) ATI_fragment_shader refers to the description of the
	    programmable fragment processing as a "fragment shader".
	    In keeping with the desire to treat all programmable parts
	    of the pipeline consistently, ATI_text_fragment_shader refers
	    to these as "fragment programs".  The name of the extension is
	    left as ATI_text_fragment_shader instead of
	    ATI_text_fragment_program in order to indicate the underlying
	    similarity between the API's of the two extensions, and to
	    differentiate it from any other potential extensions that
	    may be able to move even further in the direction of treating
	    fragment programs as just another programmable area of the
	    GL pipeline.
	
	Although ATI_fragment_shader was originally conceived as a
	device-independent extension that would expose the capabilities of
	future generations of hardware, changing trends in programmable
	hardware have affected the lifespan of this extension.  For this
	reason you will now find a fixed set of features and resources
	exposed, and the queries to determine this set have been deprecated
	in ATI_fragment_shader.  Further, in ATI_text_fragment_shader,
	most of these resource limits are fixed by the text grammar and 
	the queries have been removed altogether.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ATI/text_fragment_shader.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ATI.text_fragment_shader import *
from OpenGL.raw.GL.ATI.text_fragment_shader import _EXTENSION_NAME

def glInitTextFragmentShaderATI():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
