'''OpenGL extension ATI.vertex_streams

This module customises the behaviour of the 
OpenGL.raw.GL.ATI.vertex_streams to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds the ability to handle sets of auxilliary
	vertex and normal coordinates. These sets of auxilliary
	coordinates are termed streams, and can be routed selectively
	into the blend stages provided by the vertex blending extension.
	This functionality enables software animation techniques such
	as keyframe vertex morphing.
	
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ATI/vertex_streams.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ATI.vertex_streams import *
from OpenGL.raw.GL.ATI.vertex_streams import _EXTENSION_NAME

def glInitVertexStreamsATI():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

glVertexStream1svATI=wrapper.wrapper(glVertexStream1svATI).setInputArraySize(
    'coords', 1
)
glVertexStream1ivATI=wrapper.wrapper(glVertexStream1ivATI).setInputArraySize(
    'coords', 1
)
glVertexStream1fvATI=wrapper.wrapper(glVertexStream1fvATI).setInputArraySize(
    'coords', 1
)
glVertexStream1dvATI=wrapper.wrapper(glVertexStream1dvATI).setInputArraySize(
    'coords', 1
)
glVertexStream2svATI=wrapper.wrapper(glVertexStream2svATI).setInputArraySize(
    'coords', 2
)
glVertexStream2ivATI=wrapper.wrapper(glVertexStream2ivATI).setInputArraySize(
    'coords', 2
)
glVertexStream2fvATI=wrapper.wrapper(glVertexStream2fvATI).setInputArraySize(
    'coords', 2
)
glVertexStream2dvATI=wrapper.wrapper(glVertexStream2dvATI).setInputArraySize(
    'coords', 2
)
glVertexStream3svATI=wrapper.wrapper(glVertexStream3svATI).setInputArraySize(
    'coords', 3
)
glVertexStream3ivATI=wrapper.wrapper(glVertexStream3ivATI).setInputArraySize(
    'coords', 3
)
glVertexStream3fvATI=wrapper.wrapper(glVertexStream3fvATI).setInputArraySize(
    'coords', 3
)
glVertexStream3dvATI=wrapper.wrapper(glVertexStream3dvATI).setInputArraySize(
    'coords', 3
)
glVertexStream4svATI=wrapper.wrapper(glVertexStream4svATI).setInputArraySize(
    'coords', 4
)
glVertexStream4ivATI=wrapper.wrapper(glVertexStream4ivATI).setInputArraySize(
    'coords', 4
)
glVertexStream4fvATI=wrapper.wrapper(glVertexStream4fvATI).setInputArraySize(
    'coords', 4
)
glVertexStream4dvATI=wrapper.wrapper(glVertexStream4dvATI).setInputArraySize(
    'coords', 4
)
glNormalStream3bvATI=wrapper.wrapper(glNormalStream3bvATI).setInputArraySize(
    'coords', 3
)
glNormalStream3svATI=wrapper.wrapper(glNormalStream3svATI).setInputArraySize(
    'coords', 3
)
glNormalStream3ivATI=wrapper.wrapper(glNormalStream3ivATI).setInputArraySize(
    'coords', 3
)
glNormalStream3fvATI=wrapper.wrapper(glNormalStream3fvATI).setInputArraySize(
    'coords', 3
)
glNormalStream3dvATI=wrapper.wrapper(glNormalStream3dvATI).setInputArraySize(
    'coords', 3
)
### END AUTOGENERATED SECTION
