'''OpenGL extension EXT.light_texture

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.light_texture to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension defines a general mechanism for substituting the
	fragment color computed during texture environment processing in
	place of other fragment attributes such as the fragment normal, or
	as sources for some of the computations in the fragment processing
	pipeline, for example as material or light parameters in the
	fragment lighting computations.
	
	
	Cf ----------------------+
	                         |                 +-> to lighting parameters
	                         v                 |
	+------------+        +--------+     +-------------+
	|            |        |        |     |             |
	| texel      |------->| texenv |-----| texture     |---> Cf' (to Light Environment
	| generation |        |        |     | application |          or Fog)
	|            |        |        |     |             |
	+------------+        +--------+     +-------------+
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/light_texture.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.light_texture import *
from OpenGL.raw.GL.EXT.light_texture import _EXTENSION_NAME

def glInitLightTextureEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
