'''OpenGL extension EXT.pixel_transform_color_table

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.pixel_transform_color_table to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension defines a color table that is applied immediately
	after the pixel transformation operation.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/pixel_transform_color_table.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.pixel_transform_color_table import *
from OpenGL.raw.GL.EXT.pixel_transform_color_table import _EXTENSION_NAME

def glInitPixelTransformColorTableEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
