'''OpenGL extension EXT.rescale_normal

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.rescale_normal to provide a more 
Python-friendly API

Overview (from the spec)
	
	When normal rescaling is enabled a new operation is added to the
	transformation of the normal vector into eye coordinates.  The normal vector 
	is rescaled after it is multiplied by the inverse modelview matrix and 
	before it is normalized.  
	
	The rescale factor is chosen so that in many cases normal vectors with unit
	length in object coordinates will not need to be normalized as they
	are transformed into eye coordinates.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/rescale_normal.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.rescale_normal import *
from OpenGL.raw.GL.EXT.rescale_normal import _EXTENSION_NAME

def glInitRescaleNormalEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
