'''OpenGL extension EXT.shader_image_load_formatted

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.shader_image_load_formatted to provide a more 
Python-friendly API

Overview (from the spec)
	
	ARB_shader_image_load_store (and OpenGL 4.2) added support for
	random access load and store from/to texture images, but due to 
	hardware limitations, loads were required to declare the image
	format in the shader source. This extension relaxes that 
	requirement, and the return values from imageLoad can be format-
	converted based on the format of the image binding.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/shader_image_load_formatted.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.shader_image_load_formatted import *
from OpenGL.raw.GL.EXT.shader_image_load_formatted import _EXTENSION_NAME

def glInitShaderImageLoadFormattedEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
