'''OpenGL extension EXT.texture

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.texture to provide a more 
Python-friendly API

Overview (from the spec)
	
	The original intention of this extension was simply to support various
	numeric resolutions of color components in texture images.  While it
	accomplishes this, it also accomplishes a larger task, that of
	formalizing the notion of an internal format for images, corresponding
	to the external format that already existed for image data in host
	memory.  This notion of an internal image format will be used
	extensively in later extensions, especially those concerned with pixel
	manipulation.
	
	The idea of an internal format is simple: rather than treating a
	retained image as having 1, 2, 3, or 4 components, treat it as though
	it has a specific format, such as LUMINANCE_ALPHA, or just ALPHA.  Then
	define the semantics of the use of internal images with these formats in
	a consistent way.  Because texture mapping is already defined in GL, the
	semantics for internal-format images were chosen to match those of the 1,
	2, 3, and 4 component internal images that already existed.  The new
	semantics are a superset of the old ones, however, so this extension
	adds capabilities to GL, as well as allowing internal resolutions to be
	specified.
	
	This extension also defines a robust method for applications to
	determine what combinations of texture dimensions and resolutions are
	supported by an implementation.  It also introduces a new texture
	environment: REPLACE_EXT.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/texture.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.texture import *
from OpenGL.raw.GL.EXT.texture import _EXTENSION_NAME

def glInitTextureEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
