'''OpenGL extension EXT.texture_integer

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.texture_integer to provide a more 
Python-friendly API

Overview (from the spec)
	
	Fixed-point textures in unextended OpenGL have integer components,
	but those values are taken to represent floating-point values in
	the range [0,1].  These integer components are considered
	"normalized" integers.  When such a texture is accessed by a
	shader or by fixed-function fragment processing, floating-point
	values are returned.
	
	This extension provides a set of new "unnormalized" integer texture
	formats.  Formats with both signed and unsigned integers are provided.  In
	these formats, the components are treated as true integers.  When such
	textures are accessed by a shader, actual integer values are returned.
	
	Pixel operations that read from or write to a texture or color
	buffer with unnormalized integer components follow a path similar
	to that used for color index pixel operations, except that more
	than one component may be provided at once.  Integer values flow
	through the pixel processing pipe, and no pixel transfer
	operations are performed.  Integer format enumerants used for such
	operations indicate unnormalized integer data.
	
	Textures or render buffers with unnormalized integer formats may also be
	attached to framebuffer objects to receive fragment color values written
	by a fragment shader.  Per-fragment operations that require floating-point
	color components, including multisample alpha operations, alpha test,
	blending, and dithering, have no effect when the corresponding colors are
	written to an integer color buffer.  The NV_gpu_program4 and
	EXT_gpu_shader4 extensions add the capability to fragment programs and
	fragment shaders to write signed and unsigned integer output values.
	
	This extension does not enforce type consistency for texture accesses or
	between fragment shaders and the corresponding framebuffer attachments.
	The results of a texture lookup from an integer texture are undefined:
	
	  * for fixed-function fragment processing, or
	
	  * for shader texture accesses expecting floating-point return values.  
	
	The color components used for per-fragment operations and written into a
	color buffer are undefined:
	
	  * for fixed-function fragment processing with an integer color buffer,
	
	  * for fragment shaders that write floating-point color components to an
	    integer color buffer, or
	
	  * for fragment shaders that write integer color components to a color
	    buffer with floating point or normalized integer components.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/texture_integer.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.texture_integer import *
from OpenGL.raw.GL.EXT.texture_integer import _EXTENSION_NAME

def glInitTextureIntegerEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glTexParameterIivEXT.params size not checked against 'pname'
glTexParameterIivEXT=wrapper.wrapper(glTexParameterIivEXT).setInputArraySize(
    'params', None
)
# INPUT glTexParameterIuivEXT.params size not checked against 'pname'
glTexParameterIuivEXT=wrapper.wrapper(glTexParameterIuivEXT).setInputArraySize(
    'params', None
)
glGetTexParameterIivEXT=wrapper.wrapper(glGetTexParameterIivEXT).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetTexParameterIuivEXT=wrapper.wrapper(glGetTexParameterIuivEXT).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
### END AUTOGENERATED SECTION
