'''OpenGL extension NV.bindless_multi_draw_indirect_count

This module customises the behaviour of the 
OpenGL.raw.GL.NV.bindless_multi_draw_indirect_count to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds the possibility to define the number of drawcalls within
	a multi-draw-indirect call from the GPU, as provided by ARB_indirect_parameters,
	for the functions added in NV_bindless_multi_draw_indirect.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/bindless_multi_draw_indirect_count.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.bindless_multi_draw_indirect_count import *
from OpenGL.raw.GL.NV.bindless_multi_draw_indirect_count import _EXTENSION_NAME

def glInitBindlessMultiDrawIndirectCountNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
