'''OpenGL extension NV.fog_distance

This module customises the behaviour of the 
OpenGL.raw.GL.NV.fog_distance to provide a more 
Python-friendly API

Overview (from the spec)
	
	Ideally, the fog distance (used to compute the fog factor as
	described in Section 3.10) should be computed as the per-fragment
	Euclidean distance to the fragment center from the eye.  In practice,
	implementations "may choose to approximate the eye-coordinate
	distance from the eye to each fragment center by abs(ze).  Further,
	[the fog factor] f need not be computed at each fragment, but may
	be computed at each vertex and interpolated as other data are."
	
	This extension provides the application specific control over how
	OpenGL computes the distance used in computing the fog factor.
	
	The extension supports three fog distance modes: "eye plane absolute",
	where the fog distance is the absolute planar distance from the eye
	plane (i.e., OpenGL's standard implementation allowance as cited above);
	"eye plane", where the fog distance is the signed planar distance
	from the eye plane; and "eye radial", where the fog distance is
	computed as a Euclidean distance.  In the case of the eye radial
	fog distance mode, the distance may be computed per-vertex and then
	interpolated per-fragment.
	
	The intent of this extension is to provide applications with better
	control over the tradeoff between performance and fog quality.
	The "eye planar" modes (signed or absolute) are straightforward
	to implement with good performance, but scenes are consistently
	under-fogged at the edges of the field of view.  The "eye radial"
	mode can provide for more accurate fog at the edges of the field of
	view, but this assumes that either the eye radial fog distance is
	computed per-fragment, or if the fog distance is computed per-vertex
	and then interpolated per-fragment, then the scene must be
	sufficiently tessellated.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/fog_distance.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.fog_distance import *
from OpenGL.raw.GL.NV.fog_distance import _EXTENSION_NAME

def glInitFogDistanceNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
