'''OpenGL extension NV.texture_barrier

This module customises the behaviour of the 
OpenGL.raw.GL.NV.texture_barrier to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension relaxes the restrictions on rendering to a currently
	bound texture and provides a mechanism to avoid read-after-write
	hazards.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/texture_barrier.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.texture_barrier import *
from OpenGL.raw.GL.NV.texture_barrier import _EXTENSION_NAME

def glInitTextureBarrierNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
