'''OpenGL extension NV.vertex_program3

This module customises the behaviour of the 
OpenGL.raw.GL.NV.vertex_program3 to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension, like the NV_vertex_program2_option extension,
	provides additional vertex program functionality to extend the
	standard ARB_vertex_program language and execution environment.
	ARB programs wishing to use this added functionality need only add:
	
	    OPTION NV_vertex_program3;
	
	to the beginning of their vertex programs.
	
	New functionality provided by this extension, above and beyond that
	already provided by NV_vertex_program2_option extension, includes: 
	
	    * texture lookups in vertex programs,
	
	    * ability to push and pop address registers on the stack,
	
	    * address register-relative addressing for vertex attribute and
	      result arrays, and
	
	    * a second four-component condition code.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/vertex_program3.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.vertex_program3 import *
from OpenGL.raw.GL.NV.vertex_program3 import _EXTENSION_NAME

def glInitVertexProgram3NV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
