'''OpenGL extension NVX.gpu_memory_info

This module customises the behaviour of the 
OpenGL.raw.GL.NVX.gpu_memory_info to provide a more 
Python-friendly API

Overview (from the spec)
	
	Most graphics systems offer a limited amount of onboard
	high-performance memory for storing textures, geometric
	primitives, and other data used for rendering.
	
	OpenGL implementations are expected to manage the residence of
	objects (that is, the memory pools in which objects are placed)
	automatically.  This is simple for applications to use, and the
	high level of abstraction allows many different underlying
	hardware implementations.  However performance sensitive 
	applications that are willing to adjust their usage of these memory 
	resources in order to maintain their desired performance are unable 
	to determine when the limited onboard memory resources are 
	approaching full utilization and swapping (with its related 
	performance impact) is imminent.
	
	GL_NVX_gpu_memory_info provides applications visibility into GPU 
	hardware memory utilization in order to allow the application to 
	effectively manage its resource allocations in the scope of the 
	current available GPU memory.  This information is made available 
	to the applications in the form of the total available resource 
	size (after initial system allocations) and the current available 
	resource (e.g. free memory) as well as a count of the number and
	total size of evictions of data from GPU memory since the last time
	this information was queried from this context using this extension.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NVX/gpu_memory_info.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NVX.gpu_memory_info import *
from OpenGL.raw.GL.NVX.gpu_memory_info import _EXTENSION_NAME

def glInitGpuMemoryInfoNVX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
