'''OpenGL extension PGI.misc_hints

This module customises the behaviour of the 
OpenGL.raw.GL.PGI.misc_hints to provide a more 
Python-friendly API

Overview (from the spec)
	
	The extension allows the app to give various hints regarding 
	desired level of conformance, performance, features, etc.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/PGI/misc_hints.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.PGI.misc_hints import *
from OpenGL.raw.GL.PGI.misc_hints import _EXTENSION_NAME

def glInitMiscHintsPGI():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
