'''OpenGL extension SGIS.texture_lod

This module customises the behaviour of the 
OpenGL.raw.GL.SGIS.texture_lod to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension imposes two constraints related to the texture level of
	detail parameter LOD, which is represented by the Greek character lambda
	in the GL Specification.  One constraint clamps LOD to a specified
	floating point range.  The other limits the selection of mipmap image
	arrays to a subset of the arrays that would otherwise be considered.
	
	Together these constraints allow a large texture to be loaded and
	used initially at low resolution, and to have its resolution raised
	gradually as more resolution is desired or available.  Image array
	specification is necessarily integral, rather than continuous.  By
	providing separate, continuous clamping of the LOD parameter, it is
	possible to avoid "popping" artifacts when higher resolution images
	are provided.
	
	Note: because the shape of the mipmap array is always determined by
	the dimensions of the level 0 array, this array must be loaded for
	mipmapping to be active.  If the level 0 array is specified with a
	null image pointer, however, no actual data transfer will take
	place.  And a sufficiently tuned implementation might not even
	allocate space for a level 0 array so specified until true image
	data were presented.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIS/texture_lod.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.SGIS.texture_lod import *
from OpenGL.raw.GL.SGIS.texture_lod import _EXTENSION_NAME

def glInitTextureLodSGIS():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
