'''OpenGL extension SGIX.fragment_lighting

This module customises the behaviour of the 
OpenGL.raw.GL.SGIX.fragment_lighting to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIX/fragment_lighting.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.SGIX.fragment_lighting import *
from OpenGL.raw.GL.SGIX.fragment_lighting import _EXTENSION_NAME

def glInitFragmentLightingSGIX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glFragmentLightfvSGIX.params size not checked against 'pname'
glFragmentLightfvSGIX=wrapper.wrapper(glFragmentLightfvSGIX).setInputArraySize(
    'params', None
)
# INPUT glFragmentLightivSGIX.params size not checked against 'pname'
glFragmentLightivSGIX=wrapper.wrapper(glFragmentLightivSGIX).setInputArraySize(
    'params', None
)
# INPUT glFragmentLightModelfvSGIX.params size not checked against 'pname'
glFragmentLightModelfvSGIX=wrapper.wrapper(glFragmentLightModelfvSGIX).setInputArraySize(
    'params', None
)
# INPUT glFragmentLightModelivSGIX.params size not checked against 'pname'
glFragmentLightModelivSGIX=wrapper.wrapper(glFragmentLightModelivSGIX).setInputArraySize(
    'params', None
)
# INPUT glFragmentMaterialfvSGIX.params size not checked against 'pname'
glFragmentMaterialfvSGIX=wrapper.wrapper(glFragmentMaterialfvSGIX).setInputArraySize(
    'params', None
)
# INPUT glFragmentMaterialivSGIX.params size not checked against 'pname'
glFragmentMaterialivSGIX=wrapper.wrapper(glFragmentMaterialivSGIX).setInputArraySize(
    'params', None
)
glGetFragmentLightfvSGIX=wrapper.wrapper(glGetFragmentLightfvSGIX).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetFragmentLightivSGIX=wrapper.wrapper(glGetFragmentLightivSGIX).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetFragmentMaterialfvSGIX=wrapper.wrapper(glGetFragmentMaterialfvSGIX).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetFragmentMaterialivSGIX=wrapper.wrapper(glGetFragmentMaterialivSGIX).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
### END AUTOGENERATED SECTION
