'''OpenGL extension VERSION.GL_2_1

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_2_1 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/VERSION/GL_2_1.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.VERSION.GL_2_1 import *
from OpenGL.raw.GL.VERSION.GL_2_1 import _EXTENSION_NAME

def glInitGl21VERSION():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glUniformMatrix2x3fv.value size not checked against count*6
glUniformMatrix2x3fv=wrapper.wrapper(glUniformMatrix2x3fv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix3x2fv.value size not checked against count*6
glUniformMatrix3x2fv=wrapper.wrapper(glUniformMatrix3x2fv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix2x4fv.value size not checked against count*8
glUniformMatrix2x4fv=wrapper.wrapper(glUniformMatrix2x4fv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix4x2fv.value size not checked against count*8
glUniformMatrix4x2fv=wrapper.wrapper(glUniformMatrix4x2fv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix3x4fv.value size not checked against count*12
glUniformMatrix3x4fv=wrapper.wrapper(glUniformMatrix3x4fv).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix4x3fv.value size not checked against count*12
glUniformMatrix4x3fv=wrapper.wrapper(glUniformMatrix4x3fv).setInputArraySize(
    'value', None
)
### END AUTOGENERATED SECTION
