'''OpenGL extension QCOM.driver_control

This module customises the behaviour of the 
OpenGL.raw.GLES1.QCOM.driver_control to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/QCOM/driver_control.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES1 import _types, _glgets
from OpenGL.raw.GLES1.QCOM.driver_control import *
from OpenGL.raw.GLES1.QCOM.driver_control import _EXTENSION_NAME

def glInitDriverControlQCOM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glGetDriverControlsQCOM.driverControls size not checked against size
glGetDriverControlsQCOM=wrapper.wrapper(glGetDriverControlsQCOM).setInputArraySize(
    'driverControls', None
)
# INPUT glGetDriverControlStringQCOM.driverControlString size not checked against bufSize
glGetDriverControlStringQCOM=wrapper.wrapper(glGetDriverControlStringQCOM).setInputArraySize(
    'driverControlString', None
)
### END AUTOGENERATED SECTION
