'''OpenGL extension EXT.base_instance

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.base_instance to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/base_instance.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.base_instance import *
from OpenGL.raw.GLES2.EXT.base_instance import _EXTENSION_NAME

def glInitBaseInstanceEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glDrawElementsInstancedBaseInstanceEXT.indices size not checked against count
glDrawElementsInstancedBaseInstanceEXT=wrapper.wrapper(glDrawElementsInstancedBaseInstanceEXT).setInputArraySize(
    'indices', None
)
# INPUT glDrawElementsInstancedBaseVertexBaseInstanceEXT.indices size not checked against count
glDrawElementsInstancedBaseVertexBaseInstanceEXT=wrapper.wrapper(glDrawElementsInstancedBaseVertexBaseInstanceEXT).setInputArraySize(
    'indices', None
)
### END AUTOGENERATED SECTION
