'''OpenGL extension EXT.multi_draw_indirect

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.multi_draw_indirect to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/multi_draw_indirect.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.multi_draw_indirect import *
from OpenGL.raw.GLES2.EXT.multi_draw_indirect import _EXTENSION_NAME

def glInitMultiDrawIndirectEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glMultiDrawArraysIndirectEXT.indirect size not checked against 'drawcount,stride'
glMultiDrawArraysIndirectEXT=wrapper.wrapper(glMultiDrawArraysIndirectEXT).setInputArraySize(
    'indirect', None
)
# INPUT glMultiDrawElementsIndirectEXT.indirect size not checked against 'drawcount,stride'
glMultiDrawElementsIndirectEXT=wrapper.wrapper(glMultiDrawElementsIndirectEXT).setInputArraySize(
    'indirect', None
)
### END AUTOGENERATED SECTION
