'''OpenGL extension NV.bindless_texture

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.bindless_texture to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/bindless_texture.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.bindless_texture import *
from OpenGL.raw.GLES2.NV.bindless_texture import _EXTENSION_NAME

def glInitBindlessTextureNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glUniformHandleui64vNV.value size not checked against count
glUniformHandleui64vNV=wrapper.wrapper(glUniformHandleui64vNV).setInputArraySize(
    'value', None
)
# INPUT glProgramUniformHandleui64vNV.values size not checked against count
glProgramUniformHandleui64vNV=wrapper.wrapper(glProgramUniformHandleui64vNV).setInputArraySize(
    'values', None
)
### END AUTOGENERATED SECTION
