'''OpenGL extension NV.non_square_matrices

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.non_square_matrices to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/non_square_matrices.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.non_square_matrices import *
from OpenGL.raw.GLES2.NV.non_square_matrices import _EXTENSION_NAME

def glInitNonSquareMatricesNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glUniformMatrix2x3fvNV.value size not checked against count*6
glUniformMatrix2x3fvNV=wrapper.wrapper(glUniformMatrix2x3fvNV).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix3x2fvNV.value size not checked against count*6
glUniformMatrix3x2fvNV=wrapper.wrapper(glUniformMatrix3x2fvNV).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix2x4fvNV.value size not checked against count*8
glUniformMatrix2x4fvNV=wrapper.wrapper(glUniformMatrix2x4fvNV).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix4x2fvNV.value size not checked against count*8
glUniformMatrix4x2fvNV=wrapper.wrapper(glUniformMatrix4x2fvNV).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix3x4fvNV.value size not checked against count*12
glUniformMatrix3x4fvNV=wrapper.wrapper(glUniformMatrix3x4fvNV).setInputArraySize(
    'value', None
)
# INPUT glUniformMatrix4x3fvNV.value size not checked against count*12
glUniformMatrix4x3fvNV=wrapper.wrapper(glUniformMatrix4x3fvNV).setInputArraySize(
    'value', None
)
### END AUTOGENERATED SECTION
