'''OpenGL extension NV.viewport_array

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.viewport_array to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/viewport_array.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.viewport_array import *
from OpenGL.raw.GLES2.NV.viewport_array import _EXTENSION_NAME

def glInitViewportArrayNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glViewportArrayvNV.v size not checked against 'count'
glViewportArrayvNV=wrapper.wrapper(glViewportArrayvNV).setInputArraySize(
    'v', None
)
glViewportIndexedfvNV=wrapper.wrapper(glViewportIndexedfvNV).setInputArraySize(
    'v', 4
)
# INPUT glScissorArrayvNV.v size not checked against 'count'
glScissorArrayvNV=wrapper.wrapper(glScissorArrayvNV).setInputArraySize(
    'v', None
)
glScissorIndexedvNV=wrapper.wrapper(glScissorIndexedvNV).setInputArraySize(
    'v', 4
)
# INPUT glGetFloati_vNV.data size not checked against 'target'
glGetFloati_vNV=wrapper.wrapper(glGetFloati_vNV).setInputArraySize(
    'data', None
)
### END AUTOGENERATED SECTION
