'''OpenGL extension EXT.texture_from_pixmap

This module customises the behaviour of the 
OpenGL.raw.GLX.EXT.texture_from_pixmap to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows a color buffer to be used for both rendering and
	texturing.
	
	Only color buffers of pixmaps can be used for texturing by this extension
	but other types of drawables can be supported by future extensions layered
	on top of this extension.
	
	The functionality of this extension is similar to WGL_ARB_render_texture. 
	However, the purpose of this extension is not to provide
	"render to texture" like functionality but rather the ability to bind
	an existing X drawable to a texture. Though, there is nothing that
	prohibits it from being used for "render to texture".
	
	-   Windows are problematic as they can change size and therefore are not
	    supported by this extension.
	
	-   Only a color buffer of a GLX pixmap created using an FBConfig with
	    attribute GLX_BIND_TO_TEXTURE_RGB_EXT or GLX_BIND_TO_TEXTURE_RGBA_EXT
	    set to TRUE can be bound as a texture.
	
	-   The texture internal format is determined when the color buffer
	    is associated with the texture, guaranteeing that the color 
	    buffer format is equivalent to the texture internal format.
	
	-   A client can create a complete set of mipmap images if
	    EXT_framebuffer_object is supported.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/texture_from_pixmap.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLX import _types, _glgets
from OpenGL.raw.GLX.EXT.texture_from_pixmap import *
from OpenGL.raw.GLX.EXT.texture_from_pixmap import _EXTENSION_NAME

def glInitTextureFromPixmapEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
