'''OpenGL extension EXT.visual_rating

This module customises the behaviour of the 
OpenGL.raw.GLX.EXT.visual_rating to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows servers to identify a particular GLX visual as 
	undesirable. A new visual attribute is introduced, providing a way
	for servers to specify caveats (e.g., slow) for a visual. The attribute 
	may be queried using glXGetConfig, and can therefore be used by 
	application-specific visual selection routines. The new attribute is 
	also used by glXChooseVisual to discriminate against visuals with
	caveats.
	
	This extension allows servers to export visuals with improved features
	or image quality, but lower performance or greater system burden,
	without having to have these visuals selected preferentially.  It is
	intended to insure that most applications get the "right" visual, not
	that all applications do.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/visual_rating.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLX import _types, _glgets
from OpenGL.raw.GLX.EXT.visual_rating import *
from OpenGL.raw.GLX.EXT.visual_rating import _EXTENSION_NAME

def glInitVisualRatingEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
