'''OpenGL extension SGIX.pbuffer

This module customises the behaviour of the 
OpenGL.raw.GLX.SGIX.pbuffer to provide a more 
Python-friendly API

Overview (from the spec)
	
	    This extension defines pixel buffers (GLXPbuffers, or pbuffer for
	    short). GLXPbuffers are additional non-visible rendering buffers for an
	    OpenGL renderer.  GLXPbuffers are equivalent to GLXPixmaps with the
	    following exceptions:
	
	    1.	There is no associated X pixmap. Also, since a GLXPbuffer is a GLX
	        resource, it may not be possible to render to it using X or an 
	   	X extension other than GLX.
	
	    2.	The format of the color buffers and the type and size of any
	     	associated ancillary buffers for a GLXPbuffer can only be
	        described with a GLXFBConfig -- an X Visual cannot be used.
	
	    3.	It is possible to create a GLXPbuffer whose contents may be 
		asynchronously lost at any time.
	
	    4.  GLXPbuffers can be rendered to using either direct or indirect
	        rendering contexts.
	
	    5.  The allocation of a GLXPbuffer can fail if there are insufficient
		resources (i.e., all the pbuffer memory has been allocated and 
		the implementation does not virtualize pbuffer memory.)
	
	    The intent of the pbuffer semantics is to enable implementations to
	    allocate pbuffers in non-visible frame buffer memory.  These
	    pbuffers are intended to be "static" resources, in that a program
	    will typically allocate them only once, rather than as a part of its
	    rendering loop.  (But they should be deallocated when the program is
	    no longer using them -- for example, if the program is iconified.)
	    The frame buffer resources that are associated with a pbuffer are 
	    also static, and are deallocated only when the pbuffer is destroyed, 
	    or, in the case of a "unpreserved" pbuffer, as a result of X server 
	    activity that changes its frame buffer requirements.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIX/pbuffer.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLX import _types, _glgets
from OpenGL.raw.GLX.SGIX.pbuffer import *
from OpenGL.raw.GLX.SGIX.pbuffer import _EXTENSION_NAME

def glInitPbufferSGIX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
