'''OpenGL extension SGIX.video_resize

This module customises the behaviour of the 
OpenGL.raw.GLX.SGIX.video_resize to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a means for doing swap or frame synchronous 
	resizing/panning of the area 
	that is to be magnified (or passed through) to the output
	video resolution.  The purpose of this functionality is to provide a
	means of allowing an application to draw into a smaller viewport to
	reduce the time spent doing pixel fill.  This reduced size viewport
	is then magnified up to the video output resolution using the 
	SGIX_video_resize extension.  This extension differs from SGIX_framezoom
	(number 57) in that it is post framebuffer resizing.  Over rendering
	at swap rates and panning at frame rates is possible using frame synchronous
	update instead of swap synchronous update used for the fill reduction case. 

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIX/video_resize.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLX import _types, _glgets
from OpenGL.raw.GLX.SGIX.video_resize import *
from OpenGL.raw.GLX.SGIX.video_resize import _EXTENSION_NAME

def glInitVideoResizeSGIX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION
