/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.CallableFilter;
import hudson.remoting.DelegatingExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InterceptingExecutorService
extends DelegatingExecutorService {
    private final CopyOnWriteArrayList<CallableFilter> filters = new CopyOnWriteArrayList();

    InterceptingExecutorService(ExecutorService base) {
        super(base);
    }

    public void addFilter(CallableFilter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(CallableFilter filter) {
        this.filters.remove(filter);
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(this.wrap(task));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(task, null);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return super.submit(this.wrap(task, result));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return super.invokeAll(this.wrap(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return super.invokeAll(this.wrap(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return super.invokeAny(this.wrap(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return super.invokeAny(this.wrap(tasks), timeout, unit);
    }

    private <V> Callable<V> wrap(final Runnable r, final V value) {
        return this.wrap(new Callable<V>(){

            @Override
            public V call() throws Exception {
                r.run();
                return value;
            }
        });
    }

    private <T> Collection<Callable<T>> wrap(Collection<? extends Callable<T>> callables) {
        ArrayList<Callable<T>> r = new ArrayList<Callable<T>>();
        for (Callable<T> c : callables) {
            r.add(this.wrap(c));
        }
        return r;
    }

    private <V> Callable<V> wrap(Callable<V> r) {
        for (CallableFilter f : this.filters) {
            r = this.applyFilter(r, f);
        }
        return r;
    }

    private <V> Callable<V> applyFilter(final Callable<V> inner, final CallableFilter filter) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                return filter.call(inner);
            }
        };
    }
}

