/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.CommandTransport;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SynchronousCommandTransport
extends CommandTransport {
    protected Channel channel;
    private static final Logger LOGGER = Logger.getLogger(SynchronousCommandTransport.class.getName());

    abstract Command read() throws IOException, ClassNotFoundException, InterruptedException;

    public void setup(Channel channel, CommandTransport.CommandReceiver receiver) {
        this.channel = channel;
        new ReaderThread(receiver).start();
    }

    private final class ReaderThread
    extends Thread {
        private int commandsReceived;
        private int commandsExecuted;
        private final CommandTransport.CommandReceiver receiver;

        public ReaderThread(CommandTransport.CommandReceiver receiver) {
            super("Channel reader thread: " + SynchronousCommandTransport.this.channel.getName());
            this.commandsReceived = 0;
            this.commandsExecuted = 0;
            this.receiver = receiver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String name = SynchronousCommandTransport.this.channel.getName();
            try {
                while (!SynchronousCommandTransport.this.channel.isInClosed()) {
                    Command cmd = null;
                    try {
                        cmd = SynchronousCommandTransport.this.read();
                    }
                    catch (EOFException e) {
                        IOException ioe = new IOException("Unexpected termination of the channel");
                        ioe.initCause(e);
                        throw ioe;
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.log(Level.SEVERE, "Unable to read a command (channel " + name + ")", e);
                        continue;
                    }
                    finally {
                        ++this.commandsReceived;
                        continue;
                    }
                    this.receiver.handle(cmd);
                    ++this.commandsExecuted;
                }
                SynchronousCommandTransport.this.closeRead();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "I/O error in channel " + name, e);
                SynchronousCommandTransport.this.channel.terminate((InterruptedIOException)new InterruptedIOException().initCause(e));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "I/O error in channel " + name, e);
                SynchronousCommandTransport.this.channel.terminate(e);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "Unexpected error in channel " + name, e);
                SynchronousCommandTransport.this.channel.terminate((IOException)new IOException("Unexpected reader termination").initCause(e));
                throw e;
            }
            catch (Error e) {
                LOGGER.log(Level.SEVERE, "Unexpected error in channel " + name, e);
                SynchronousCommandTransport.this.channel.terminate((IOException)new IOException("Unexpected reader termination").initCause(e));
                throw e;
            }
            finally {
                SynchronousCommandTransport.this.channel.pipeWriter.shutdown();
            }
        }
    }
}

