#
# Autogenerated by Thrift
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#

require 'thrift'
require 'cassandra_types'
require 'cassandra_constants'

    module CassandraThrift
      module Cassandra
        class Client
          include ::Thrift::Client

          def login(keyspace, auth_request)
            send_login(keyspace, auth_request)
            recv_login()
          end

          def send_login(keyspace, auth_request)
            send_message('login', Login_args, :keyspace => keyspace, :auth_request => auth_request)
          end

          def recv_login()
            result = receive_message(Login_result)
            raise result.authnx unless result.authnx.nil?
            raise result.authzx unless result.authzx.nil?
            return
          end

          def get(keyspace, key, column_path, consistency_level)
            send_get(keyspace, key, column_path, consistency_level)
            return recv_get()
          end

          def send_get(keyspace, key, column_path, consistency_level)
            send_message('get', Get_args, :keyspace => keyspace, :key => key, :column_path => column_path, :consistency_level => consistency_level)
          end

          def recv_get()
            result = receive_message(Get_result)
            return result.success unless result.success.nil?
            raise result.ire unless result.ire.nil?
            raise result.nfe unless result.nfe.nil?
            raise result.ue unless result.ue.nil?
            raise result.te unless result.te.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get failed: unknown result')
          end

          def get_slice(keyspace, key, column_parent, predicate, consistency_level)
            send_get_slice(keyspace, key, column_parent, predicate, consistency_level)
            return recv_get_slice()
          end

          def send_get_slice(keyspace, key, column_parent, predicate, consistency_level)
            send_message('get_slice', Get_slice_args, :keyspace => keyspace, :key => key, :column_parent => column_parent, :predicate => predicate, :consistency_level => consistency_level)
          end

          def recv_get_slice()
            result = receive_message(Get_slice_result)
            return result.success unless result.success.nil?
            raise result.ire unless result.ire.nil?
            raise result.ue unless result.ue.nil?
            raise result.te unless result.te.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_slice failed: unknown result')
          end

          def multiget(keyspace, keys, column_path, consistency_level)
            send_multiget(keyspace, keys, column_path, consistency_level)
            return recv_multiget()
          end

          def send_multiget(keyspace, keys, column_path, consistency_level)
            send_message('multiget', Multiget_args, :keyspace => keyspace, :keys => keys, :column_path => column_path, :consistency_level => consistency_level)
          end

          def recv_multiget()
            result = receive_message(Multiget_result)
            return result.success unless result.success.nil?
            raise result.ire unless result.ire.nil?
            raise result.ue unless result.ue.nil?
            raise result.te unless result.te.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'multiget failed: unknown result')
          end

          def multiget_slice(keyspace, keys, column_parent, predicate, consistency_level)
            send_multiget_slice(keyspace, keys, column_parent, predicate, consistency_level)
            return recv_multiget_slice()
          end

          def send_multiget_slice(keyspace, keys, column_parent, predicate, consistency_level)
            send_message('multiget_slice', Multiget_slice_args, :keyspace => keyspace, :keys => keys, :column_parent => column_parent, :predicate => predicate, :consistency_level => consistency_level)
          end

          def recv_multiget_slice()
            result = receive_message(Multiget_slice_result)
            return result.success unless result.success.nil?
            raise result.ire unless result.ire.nil?
            raise result.ue unless result.ue.nil?
            raise result.te unless result.te.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'multiget_slice failed: unknown result')
          end

          def get_count(keyspace, key, column_parent, consistency_level)
            send_get_count(keyspace, key, column_parent, consistency_level)
            return recv_get_count()
          end

          def send_get_count(keyspace, key, column_parent, consistency_level)
            send_message('get_count', Get_count_args, :keyspace => keyspace, :key => key, :column_parent => column_parent, :consistency_level => consistency_level)
          end

          def recv_get_count()
            result = receive_message(Get_count_result)
            return result.success unless result.success.nil?
            raise result.ire unless result.ire.nil?
            raise result.ue unless result.ue.nil?
            raise result.te unless result.te.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_count failed: unknown result')
          end

          def get_range_slice(keyspace, column_parent, predicate, start_key, finish_key, row_count, consistency_level)
            send_get_range_slice(keyspace, column_parent, predicate, start_key, finish_key, row_count, consistency_level)
            return recv_get_range_slice()
          end

          def send_get_range_slice(keyspace, column_parent, predicate, start_key, finish_key, row_count, consistency_level)
            send_message('get_range_slice', Get_range_slice_args, :keyspace => keyspace, :column_parent => column_parent, :predicate => predicate, :start_key => start_key, :finish_key => finish_key, :row_count => row_count, :consistency_level => consistency_level)
          end

          def recv_get_range_slice()
            result = receive_message(Get_range_slice_result)
            return result.success unless result.success.nil?
            raise result.ire unless result.ire.nil?
            raise result.ue unless result.ue.nil?
            raise result.te unless result.te.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_range_slice failed: unknown result')
          end

          def get_range_slices(keyspace, column_parent, predicate, range, consistency_level)
            send_get_range_slices(keyspace, column_parent, predicate, range, consistency_level)
            return recv_get_range_slices()
          end

          def send_get_range_slices(keyspace, column_parent, predicate, range, consistency_level)
            send_message('get_range_slices', Get_range_slices_args, :keyspace => keyspace, :column_parent => column_parent, :predicate => predicate, :range => range, :consistency_level => consistency_level)
          end

          def recv_get_range_slices()
            result = receive_message(Get_range_slices_result)
            return result.success unless result.success.nil?
            raise result.ire unless result.ire.nil?
            raise result.ue unless result.ue.nil?
            raise result.te unless result.te.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_range_slices failed: unknown result')
          end

          def insert(keyspace, key, column_path, value, timestamp, consistency_level)
            send_insert(keyspace, key, column_path, value, timestamp, consistency_level)
            recv_insert()
          end

          def send_insert(keyspace, key, column_path, value, timestamp, consistency_level)
            send_message('insert', Insert_args, :keyspace => keyspace, :key => key, :column_path => column_path, :value => value, :timestamp => timestamp, :consistency_level => consistency_level)
          end

          def recv_insert()
            result = receive_message(Insert_result)
            raise result.ire unless result.ire.nil?
            raise result.ue unless result.ue.nil?
            raise result.te unless result.te.nil?
            return
          end

          def batch_insert(keyspace, key, cfmap, consistency_level)
            send_batch_insert(keyspace, key, cfmap, consistency_level)
            recv_batch_insert()
          end

          def send_batch_insert(keyspace, key, cfmap, consistency_level)
            send_message('batch_insert', Batch_insert_args, :keyspace => keyspace, :key => key, :cfmap => cfmap, :consistency_level => consistency_level)
          end

          def recv_batch_insert()
            result = receive_message(Batch_insert_result)
            raise result.ire unless result.ire.nil?
            raise result.ue unless result.ue.nil?
            raise result.te unless result.te.nil?
            return
          end

          def remove(keyspace, key, column_path, timestamp, consistency_level)
            send_remove(keyspace, key, column_path, timestamp, consistency_level)
            recv_remove()
          end

          def send_remove(keyspace, key, column_path, timestamp, consistency_level)
            send_message('remove', Remove_args, :keyspace => keyspace, :key => key, :column_path => column_path, :timestamp => timestamp, :consistency_level => consistency_level)
          end

          def recv_remove()
            result = receive_message(Remove_result)
            raise result.ire unless result.ire.nil?
            raise result.ue unless result.ue.nil?
            raise result.te unless result.te.nil?
            return
          end

          def batch_mutate(keyspace, mutation_map, consistency_level)
            send_batch_mutate(keyspace, mutation_map, consistency_level)
            recv_batch_mutate()
          end

          def send_batch_mutate(keyspace, mutation_map, consistency_level)
            send_message('batch_mutate', Batch_mutate_args, :keyspace => keyspace, :mutation_map => mutation_map, :consistency_level => consistency_level)
          end

          def recv_batch_mutate()
            result = receive_message(Batch_mutate_result)
            raise result.ire unless result.ire.nil?
            raise result.ue unless result.ue.nil?
            raise result.te unless result.te.nil?
            return
          end

          def get_string_property(property)
            send_get_string_property(property)
            return recv_get_string_property()
          end

          def send_get_string_property(property)
            send_message('get_string_property', Get_string_property_args, :property => property)
          end

          def recv_get_string_property()
            result = receive_message(Get_string_property_result)
            return result.success unless result.success.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_string_property failed: unknown result')
          end

          def get_string_list_property(property)
            send_get_string_list_property(property)
            return recv_get_string_list_property()
          end

          def send_get_string_list_property(property)
            send_message('get_string_list_property', Get_string_list_property_args, :property => property)
          end

          def recv_get_string_list_property()
            result = receive_message(Get_string_list_property_result)
            return result.success unless result.success.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_string_list_property failed: unknown result')
          end

          def describe_keyspaces()
            send_describe_keyspaces()
            return recv_describe_keyspaces()
          end

          def send_describe_keyspaces()
            send_message('describe_keyspaces', Describe_keyspaces_args)
          end

          def recv_describe_keyspaces()
            result = receive_message(Describe_keyspaces_result)
            return result.success unless result.success.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_keyspaces failed: unknown result')
          end

          def describe_cluster_name()
            send_describe_cluster_name()
            return recv_describe_cluster_name()
          end

          def send_describe_cluster_name()
            send_message('describe_cluster_name', Describe_cluster_name_args)
          end

          def recv_describe_cluster_name()
            result = receive_message(Describe_cluster_name_result)
            return result.success unless result.success.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_cluster_name failed: unknown result')
          end

          def describe_version()
            send_describe_version()
            return recv_describe_version()
          end

          def send_describe_version()
            send_message('describe_version', Describe_version_args)
          end

          def recv_describe_version()
            result = receive_message(Describe_version_result)
            return result.success unless result.success.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_version failed: unknown result')
          end

          def describe_ring(keyspace)
            send_describe_ring(keyspace)
            return recv_describe_ring()
          end

          def send_describe_ring(keyspace)
            send_message('describe_ring', Describe_ring_args, :keyspace => keyspace)
          end

          def recv_describe_ring()
            result = receive_message(Describe_ring_result)
            return result.success unless result.success.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_ring failed: unknown result')
          end

          def describe_keyspace(keyspace)
            send_describe_keyspace(keyspace)
            return recv_describe_keyspace()
          end

          def send_describe_keyspace(keyspace)
            send_message('describe_keyspace', Describe_keyspace_args, :keyspace => keyspace)
          end

          def recv_describe_keyspace()
            result = receive_message(Describe_keyspace_result)
            return result.success unless result.success.nil?
            raise result.nfe unless result.nfe.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_keyspace failed: unknown result')
          end

          def describe_splits(start_token, end_token, keys_per_split)
            send_describe_splits(start_token, end_token, keys_per_split)
            return recv_describe_splits()
          end

          def send_describe_splits(start_token, end_token, keys_per_split)
            send_message('describe_splits', Describe_splits_args, :start_token => start_token, :end_token => end_token, :keys_per_split => keys_per_split)
          end

          def recv_describe_splits()
            result = receive_message(Describe_splits_result)
            return result.success unless result.success.nil?
            raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_splits failed: unknown result')
          end

        end

        class Processor
          include ::Thrift::Processor

          def process_login(seqid, iprot, oprot)
            args = read_args(iprot, Login_args)
            result = Login_result.new()
            begin
              @handler.login(args.keyspace, args.auth_request)
            rescue CassandraThrift::AuthenticationException => authnx
              result.authnx = authnx
            rescue CassandraThrift::AuthorizationException => authzx
              result.authzx = authzx
            end
            write_result(result, oprot, 'login', seqid)
          end

          def process_get(seqid, iprot, oprot)
            args = read_args(iprot, Get_args)
            result = Get_result.new()
            begin
              result.success = @handler.get(args.keyspace, args.key, args.column_path, args.consistency_level)
            rescue CassandraThrift::InvalidRequestException => ire
              result.ire = ire
            rescue CassandraThrift::NotFoundException => nfe
              result.nfe = nfe
            rescue CassandraThrift::UnavailableException => ue
              result.ue = ue
            rescue CassandraThrift::TimedOutException => te
              result.te = te
            end
            write_result(result, oprot, 'get', seqid)
          end

          def process_get_slice(seqid, iprot, oprot)
            args = read_args(iprot, Get_slice_args)
            result = Get_slice_result.new()
            begin
              result.success = @handler.get_slice(args.keyspace, args.key, args.column_parent, args.predicate, args.consistency_level)
            rescue CassandraThrift::InvalidRequestException => ire
              result.ire = ire
            rescue CassandraThrift::UnavailableException => ue
              result.ue = ue
            rescue CassandraThrift::TimedOutException => te
              result.te = te
            end
            write_result(result, oprot, 'get_slice', seqid)
          end

          def process_multiget(seqid, iprot, oprot)
            args = read_args(iprot, Multiget_args)
            result = Multiget_result.new()
            begin
              result.success = @handler.multiget(args.keyspace, args.keys, args.column_path, args.consistency_level)
            rescue CassandraThrift::InvalidRequestException => ire
              result.ire = ire
            rescue CassandraThrift::UnavailableException => ue
              result.ue = ue
            rescue CassandraThrift::TimedOutException => te
              result.te = te
            end
            write_result(result, oprot, 'multiget', seqid)
          end

          def process_multiget_slice(seqid, iprot, oprot)
            args = read_args(iprot, Multiget_slice_args)
            result = Multiget_slice_result.new()
            begin
              result.success = @handler.multiget_slice(args.keyspace, args.keys, args.column_parent, args.predicate, args.consistency_level)
            rescue CassandraThrift::InvalidRequestException => ire
              result.ire = ire
            rescue CassandraThrift::UnavailableException => ue
              result.ue = ue
            rescue CassandraThrift::TimedOutException => te
              result.te = te
            end
            write_result(result, oprot, 'multiget_slice', seqid)
          end

          def process_get_count(seqid, iprot, oprot)
            args = read_args(iprot, Get_count_args)
            result = Get_count_result.new()
            begin
              result.success = @handler.get_count(args.keyspace, args.key, args.column_parent, args.consistency_level)
            rescue CassandraThrift::InvalidRequestException => ire
              result.ire = ire
            rescue CassandraThrift::UnavailableException => ue
              result.ue = ue
            rescue CassandraThrift::TimedOutException => te
              result.te = te
            end
            write_result(result, oprot, 'get_count', seqid)
          end

          def process_get_range_slice(seqid, iprot, oprot)
            args = read_args(iprot, Get_range_slice_args)
            result = Get_range_slice_result.new()
            begin
              result.success = @handler.get_range_slice(args.keyspace, args.column_parent, args.predicate, args.start_key, args.finish_key, args.row_count, args.consistency_level)
            rescue CassandraThrift::InvalidRequestException => ire
              result.ire = ire
            rescue CassandraThrift::UnavailableException => ue
              result.ue = ue
            rescue CassandraThrift::TimedOutException => te
              result.te = te
            end
            write_result(result, oprot, 'get_range_slice', seqid)
          end

          def process_get_range_slices(seqid, iprot, oprot)
            args = read_args(iprot, Get_range_slices_args)
            result = Get_range_slices_result.new()
            begin
              result.success = @handler.get_range_slices(args.keyspace, args.column_parent, args.predicate, args.range, args.consistency_level)
            rescue CassandraThrift::InvalidRequestException => ire
              result.ire = ire
            rescue CassandraThrift::UnavailableException => ue
              result.ue = ue
            rescue CassandraThrift::TimedOutException => te
              result.te = te
            end
            write_result(result, oprot, 'get_range_slices', seqid)
          end

          def process_insert(seqid, iprot, oprot)
            args = read_args(iprot, Insert_args)
            result = Insert_result.new()
            begin
              @handler.insert(args.keyspace, args.key, args.column_path, args.value, args.timestamp, args.consistency_level)
            rescue CassandraThrift::InvalidRequestException => ire
              result.ire = ire
            rescue CassandraThrift::UnavailableException => ue
              result.ue = ue
            rescue CassandraThrift::TimedOutException => te
              result.te = te
            end
            write_result(result, oprot, 'insert', seqid)
          end

          def process_batch_insert(seqid, iprot, oprot)
            args = read_args(iprot, Batch_insert_args)
            result = Batch_insert_result.new()
            begin
              @handler.batch_insert(args.keyspace, args.key, args.cfmap, args.consistency_level)
            rescue CassandraThrift::InvalidRequestException => ire
              result.ire = ire
            rescue CassandraThrift::UnavailableException => ue
              result.ue = ue
            rescue CassandraThrift::TimedOutException => te
              result.te = te
            end
            write_result(result, oprot, 'batch_insert', seqid)
          end

          def process_remove(seqid, iprot, oprot)
            args = read_args(iprot, Remove_args)
            result = Remove_result.new()
            begin
              @handler.remove(args.keyspace, args.key, args.column_path, args.timestamp, args.consistency_level)
            rescue CassandraThrift::InvalidRequestException => ire
              result.ire = ire
            rescue CassandraThrift::UnavailableException => ue
              result.ue = ue
            rescue CassandraThrift::TimedOutException => te
              result.te = te
            end
            write_result(result, oprot, 'remove', seqid)
          end

          def process_batch_mutate(seqid, iprot, oprot)
            args = read_args(iprot, Batch_mutate_args)
            result = Batch_mutate_result.new()
            begin
              @handler.batch_mutate(args.keyspace, args.mutation_map, args.consistency_level)
            rescue CassandraThrift::InvalidRequestException => ire
              result.ire = ire
            rescue CassandraThrift::UnavailableException => ue
              result.ue = ue
            rescue CassandraThrift::TimedOutException => te
              result.te = te
            end
            write_result(result, oprot, 'batch_mutate', seqid)
          end

          def process_get_string_property(seqid, iprot, oprot)
            args = read_args(iprot, Get_string_property_args)
            result = Get_string_property_result.new()
            result.success = @handler.get_string_property(args.property)
            write_result(result, oprot, 'get_string_property', seqid)
          end

          def process_get_string_list_property(seqid, iprot, oprot)
            args = read_args(iprot, Get_string_list_property_args)
            result = Get_string_list_property_result.new()
            result.success = @handler.get_string_list_property(args.property)
            write_result(result, oprot, 'get_string_list_property', seqid)
          end

          def process_describe_keyspaces(seqid, iprot, oprot)
            args = read_args(iprot, Describe_keyspaces_args)
            result = Describe_keyspaces_result.new()
            result.success = @handler.describe_keyspaces()
            write_result(result, oprot, 'describe_keyspaces', seqid)
          end

          def process_describe_cluster_name(seqid, iprot, oprot)
            args = read_args(iprot, Describe_cluster_name_args)
            result = Describe_cluster_name_result.new()
            result.success = @handler.describe_cluster_name()
            write_result(result, oprot, 'describe_cluster_name', seqid)
          end

          def process_describe_version(seqid, iprot, oprot)
            args = read_args(iprot, Describe_version_args)
            result = Describe_version_result.new()
            result.success = @handler.describe_version()
            write_result(result, oprot, 'describe_version', seqid)
          end

          def process_describe_ring(seqid, iprot, oprot)
            args = read_args(iprot, Describe_ring_args)
            result = Describe_ring_result.new()
            result.success = @handler.describe_ring(args.keyspace)
            write_result(result, oprot, 'describe_ring', seqid)
          end

          def process_describe_keyspace(seqid, iprot, oprot)
            args = read_args(iprot, Describe_keyspace_args)
            result = Describe_keyspace_result.new()
            begin
              result.success = @handler.describe_keyspace(args.keyspace)
            rescue CassandraThrift::NotFoundException => nfe
              result.nfe = nfe
            end
            write_result(result, oprot, 'describe_keyspace', seqid)
          end

          def process_describe_splits(seqid, iprot, oprot)
            args = read_args(iprot, Describe_splits_args)
            result = Describe_splits_result.new()
            result.success = @handler.describe_splits(args.start_token, args.end_token, args.keys_per_split)
            write_result(result, oprot, 'describe_splits', seqid)
          end

        end

        # HELPER FUNCTIONS AND STRUCTURES

        class Login_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1
          AUTH_REQUEST = 2

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'},
            AUTH_REQUEST => {:type => ::Thrift::Types::STRUCT, :name => 'auth_request', :class => CassandraThrift::AuthenticationRequest}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field auth_request is unset!') unless @auth_request
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Login_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          AUTHNX = 1
          AUTHZX = 2

          FIELDS = {
            AUTHNX => {:type => ::Thrift::Types::STRUCT, :name => 'authnx', :class => CassandraThrift::AuthenticationException},
            AUTHZX => {:type => ::Thrift::Types::STRUCT, :name => 'authzx', :class => CassandraThrift::AuthorizationException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1
          KEY = 2
          COLUMN_PATH = 3
          CONSISTENCY_LEVEL = 4

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'},
            KEY => {:type => ::Thrift::Types::STRING, :name => 'key'},
            COLUMN_PATH => {:type => ::Thrift::Types::STRUCT, :name => 'column_path', :class => CassandraThrift::ColumnPath},
            CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>             1, :enum_class => CassandraThrift::ConsistencyLevel}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_path is unset!') unless @column_path
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
            unless @consistency_level.nil? || CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
              raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
            end
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0
          IRE = 1
          NFE = 2
          UE = 3
          TE = 4

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => CassandraThrift::ColumnOrSuperColumn},
            IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => CassandraThrift::InvalidRequestException},
            NFE => {:type => ::Thrift::Types::STRUCT, :name => 'nfe', :class => CassandraThrift::NotFoundException},
            UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => CassandraThrift::UnavailableException},
            TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => CassandraThrift::TimedOutException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_slice_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1
          KEY = 2
          COLUMN_PARENT = 3
          PREDICATE = 4
          CONSISTENCY_LEVEL = 5

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'},
            KEY => {:type => ::Thrift::Types::STRING, :name => 'key'},
            COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => CassandraThrift::ColumnParent},
            PREDICATE => {:type => ::Thrift::Types::STRUCT, :name => 'predicate', :class => CassandraThrift::SlicePredicate},
            CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>             1, :enum_class => CassandraThrift::ConsistencyLevel}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field predicate is unset!') unless @predicate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
            unless @consistency_level.nil? || CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
              raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
            end
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_slice_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0
          IRE = 1
          UE = 2
          TE = 3

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => CassandraThrift::ColumnOrSuperColumn}},
            IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => CassandraThrift::InvalidRequestException},
            UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => CassandraThrift::UnavailableException},
            TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => CassandraThrift::TimedOutException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Multiget_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1
          KEYS = 2
          COLUMN_PATH = 3
          CONSISTENCY_LEVEL = 4

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'},
            KEYS => {:type => ::Thrift::Types::LIST, :name => 'keys', :element => {:type => ::Thrift::Types::STRING}},
            COLUMN_PATH => {:type => ::Thrift::Types::STRUCT, :name => 'column_path', :class => CassandraThrift::ColumnPath},
            CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>             1, :enum_class => CassandraThrift::ConsistencyLevel}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keys is unset!') unless @keys
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_path is unset!') unless @column_path
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
            unless @consistency_level.nil? || CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
              raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
            end
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Multiget_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0
          IRE = 1
          UE = 2
          TE = 3

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::MAP, :name => 'success', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::STRUCT, :class => CassandraThrift::ColumnOrSuperColumn}},
            IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => CassandraThrift::InvalidRequestException},
            UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => CassandraThrift::UnavailableException},
            TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => CassandraThrift::TimedOutException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Multiget_slice_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1
          KEYS = 2
          COLUMN_PARENT = 3
          PREDICATE = 4
          CONSISTENCY_LEVEL = 5

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'},
            KEYS => {:type => ::Thrift::Types::LIST, :name => 'keys', :element => {:type => ::Thrift::Types::STRING}},
            COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => CassandraThrift::ColumnParent},
            PREDICATE => {:type => ::Thrift::Types::STRUCT, :name => 'predicate', :class => CassandraThrift::SlicePredicate},
            CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>             1, :enum_class => CassandraThrift::ConsistencyLevel}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keys is unset!') unless @keys
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field predicate is unset!') unless @predicate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
            unless @consistency_level.nil? || CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
              raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
            end
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Multiget_slice_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0
          IRE = 1
          UE = 2
          TE = 3

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::MAP, :name => 'success', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::LIST, :element => {:type => ::Thrift::Types::STRUCT, :class => CassandraThrift::ColumnOrSuperColumn}}},
            IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => CassandraThrift::InvalidRequestException},
            UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => CassandraThrift::UnavailableException},
            TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => CassandraThrift::TimedOutException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_count_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1
          KEY = 2
          COLUMN_PARENT = 3
          CONSISTENCY_LEVEL = 4

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'},
            KEY => {:type => ::Thrift::Types::STRING, :name => 'key'},
            COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => CassandraThrift::ColumnParent},
            CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>             1, :enum_class => CassandraThrift::ConsistencyLevel}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
            unless @consistency_level.nil? || CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
              raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
            end
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_count_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0
          IRE = 1
          UE = 2
          TE = 3

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::I32, :name => 'success'},
            IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => CassandraThrift::InvalidRequestException},
            UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => CassandraThrift::UnavailableException},
            TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => CassandraThrift::TimedOutException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_range_slice_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1
          COLUMN_PARENT = 2
          PREDICATE = 3
          START_KEY = 4
          FINISH_KEY = 5
          ROW_COUNT = 6
          CONSISTENCY_LEVEL = 7

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'},
            COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => CassandraThrift::ColumnParent},
            PREDICATE => {:type => ::Thrift::Types::STRUCT, :name => 'predicate', :class => CassandraThrift::SlicePredicate},
            START_KEY => {:type => ::Thrift::Types::STRING, :name => 'start_key', :default => %q""},
            FINISH_KEY => {:type => ::Thrift::Types::STRING, :name => 'finish_key', :default => %q""},
            ROW_COUNT => {:type => ::Thrift::Types::I32, :name => 'row_count', :default => 100},
            CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>             1, :enum_class => CassandraThrift::ConsistencyLevel}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field predicate is unset!') unless @predicate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field start_key is unset!') unless @start_key
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field finish_key is unset!') unless @finish_key
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field row_count is unset!') unless @row_count
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
            unless @consistency_level.nil? || CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
              raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
            end
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_range_slice_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0
          IRE = 1
          UE = 2
          TE = 3

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => CassandraThrift::KeySlice}},
            IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => CassandraThrift::InvalidRequestException},
            UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => CassandraThrift::UnavailableException},
            TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => CassandraThrift::TimedOutException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_range_slices_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1
          COLUMN_PARENT = 2
          PREDICATE = 3
          RANGE = 4
          CONSISTENCY_LEVEL = 5

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'},
            COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => CassandraThrift::ColumnParent},
            PREDICATE => {:type => ::Thrift::Types::STRUCT, :name => 'predicate', :class => CassandraThrift::SlicePredicate},
            RANGE => {:type => ::Thrift::Types::STRUCT, :name => 'range', :class => CassandraThrift::KeyRange},
            CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>             1, :enum_class => CassandraThrift::ConsistencyLevel}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field predicate is unset!') unless @predicate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field range is unset!') unless @range
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
            unless @consistency_level.nil? || CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
              raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
            end
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_range_slices_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0
          IRE = 1
          UE = 2
          TE = 3

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => CassandraThrift::KeySlice}},
            IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => CassandraThrift::InvalidRequestException},
            UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => CassandraThrift::UnavailableException},
            TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => CassandraThrift::TimedOutException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Insert_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1
          KEY = 2
          COLUMN_PATH = 3
          VALUE = 4
          TIMESTAMP = 5
          CONSISTENCY_LEVEL = 6

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'},
            KEY => {:type => ::Thrift::Types::STRING, :name => 'key'},
            COLUMN_PATH => {:type => ::Thrift::Types::STRUCT, :name => 'column_path', :class => CassandraThrift::ColumnPath},
            VALUE => {:type => ::Thrift::Types::STRING, :name => 'value', :binary => true},
            TIMESTAMP => {:type => ::Thrift::Types::I64, :name => 'timestamp'},
            CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>             1, :enum_class => CassandraThrift::ConsistencyLevel}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_path is unset!') unless @column_path
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field value is unset!') unless @value
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field timestamp is unset!') unless @timestamp
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
            unless @consistency_level.nil? || CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
              raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
            end
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Insert_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          IRE = 1
          UE = 2
          TE = 3

          FIELDS = {
            IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => CassandraThrift::InvalidRequestException},
            UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => CassandraThrift::UnavailableException},
            TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => CassandraThrift::TimedOutException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Batch_insert_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1
          KEY = 2
          CFMAP = 3
          CONSISTENCY_LEVEL = 4

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'},
            KEY => {:type => ::Thrift::Types::STRING, :name => 'key'},
            CFMAP => {:type => ::Thrift::Types::MAP, :name => 'cfmap', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::LIST, :element => {:type => ::Thrift::Types::STRUCT, :class => CassandraThrift::ColumnOrSuperColumn}}},
            CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>             1, :enum_class => CassandraThrift::ConsistencyLevel}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field cfmap is unset!') unless @cfmap
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
            unless @consistency_level.nil? || CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
              raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
            end
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Batch_insert_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          IRE = 1
          UE = 2
          TE = 3

          FIELDS = {
            IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => CassandraThrift::InvalidRequestException},
            UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => CassandraThrift::UnavailableException},
            TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => CassandraThrift::TimedOutException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Remove_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1
          KEY = 2
          COLUMN_PATH = 3
          TIMESTAMP = 4
          CONSISTENCY_LEVEL = 5

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'},
            KEY => {:type => ::Thrift::Types::STRING, :name => 'key'},
            COLUMN_PATH => {:type => ::Thrift::Types::STRUCT, :name => 'column_path', :class => CassandraThrift::ColumnPath},
            TIMESTAMP => {:type => ::Thrift::Types::I64, :name => 'timestamp'},
            CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>             1, :enum_class => CassandraThrift::ConsistencyLevel}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_path is unset!') unless @column_path
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field timestamp is unset!') unless @timestamp
            unless @consistency_level.nil? || CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
              raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
            end
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Remove_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          IRE = 1
          UE = 2
          TE = 3

          FIELDS = {
            IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => CassandraThrift::InvalidRequestException},
            UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => CassandraThrift::UnavailableException},
            TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => CassandraThrift::TimedOutException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Batch_mutate_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1
          MUTATION_MAP = 2
          CONSISTENCY_LEVEL = 3

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'},
            MUTATION_MAP => {:type => ::Thrift::Types::MAP, :name => 'mutation_map', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::MAP, :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::LIST, :element => {:type => ::Thrift::Types::STRUCT, :class => CassandraThrift::Mutation}}}},
            CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>             1, :enum_class => CassandraThrift::ConsistencyLevel}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field mutation_map is unset!') unless @mutation_map
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
            unless @consistency_level.nil? || CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
              raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
            end
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Batch_mutate_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          IRE = 1
          UE = 2
          TE = 3

          FIELDS = {
            IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => CassandraThrift::InvalidRequestException},
            UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => CassandraThrift::UnavailableException},
            TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => CassandraThrift::TimedOutException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_string_property_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          PROPERTY = 1

          FIELDS = {
            PROPERTY => {:type => ::Thrift::Types::STRING, :name => 'property'}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field property is unset!') unless @property
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_string_property_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_string_list_property_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          PROPERTY = 1

          FIELDS = {
            PROPERTY => {:type => ::Thrift::Types::STRING, :name => 'property'}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field property is unset!') unless @property
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Get_string_list_property_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Describe_keyspaces_args
          include ::Thrift::Struct, ::Thrift::Struct_Union

          FIELDS = {

          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Describe_keyspaces_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::SET, :name => 'success', :element => {:type => ::Thrift::Types::STRING}}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Describe_cluster_name_args
          include ::Thrift::Struct, ::Thrift::Struct_Union

          FIELDS = {

          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Describe_cluster_name_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Describe_version_args
          include ::Thrift::Struct, ::Thrift::Struct_Union

          FIELDS = {

          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Describe_version_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Describe_ring_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Describe_ring_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => CassandraThrift::TokenRange}}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Describe_keyspace_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          KEYSPACE = 1

          FIELDS = {
            KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Describe_keyspace_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0
          NFE = 1

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::MAP, :name => 'success', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::MAP, :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::STRING}}},
            NFE => {:type => ::Thrift::Types::STRUCT, :name => 'nfe', :class => CassandraThrift::NotFoundException}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Describe_splits_args
          include ::Thrift::Struct, ::Thrift::Struct_Union
          START_TOKEN = 1
          END_TOKEN = 2
          KEYS_PER_SPLIT = 3

          FIELDS = {
            START_TOKEN => {:type => ::Thrift::Types::STRING, :name => 'start_token'},
            END_TOKEN => {:type => ::Thrift::Types::STRING, :name => 'end_token'},
            KEYS_PER_SPLIT => {:type => ::Thrift::Types::I32, :name => 'keys_per_split'}
          }

          def struct_fields; FIELDS; end

          def validate
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field start_token is unset!') unless @start_token
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field end_token is unset!') unless @end_token
            raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keys_per_split is unset!') unless @keys_per_split
          end

          ::Thrift::Struct.generate_accessors self
        end

        class Describe_splits_result
          include ::Thrift::Struct, ::Thrift::Struct_Union
          SUCCESS = 0

          FIELDS = {
            SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}}
          }

          def struct_fields; FIELDS; end

          def validate
          end

          ::Thrift::Struct.generate_accessors self
        end

      end

    end
