#
# Autogenerated by Thrift Compiler (0.9.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#

require 'thrift'
require 'cassandra_types'

module CassandraThrift
  module Cassandra
    class Client
      include ::Thrift::Client

      def login(auth_request)
        send_login(auth_request)
        recv_login()
      end

      def send_login(auth_request)
        send_message('login', Login_args, :auth_request => auth_request)
      end

      def recv_login()
        result = receive_message(Login_result)
        raise result.authnx unless result.authnx.nil?
        raise result.authzx unless result.authzx.nil?
        return
      end

      def set_keyspace(keyspace)
        send_set_keyspace(keyspace)
        recv_set_keyspace()
      end

      def send_set_keyspace(keyspace)
        send_message('set_keyspace', Set_keyspace_args, :keyspace => keyspace)
      end

      def recv_set_keyspace()
        result = receive_message(Set_keyspace_result)
        raise result.ire unless result.ire.nil?
        return
      end

      def get(key, column_path, consistency_level)
        send_get(key, column_path, consistency_level)
        return recv_get()
      end

      def send_get(key, column_path, consistency_level)
        send_message('get', Get_args, :key => key, :column_path => column_path, :consistency_level => consistency_level)
      end

      def recv_get()
        result = receive_message(Get_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.nfe unless result.nfe.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get failed: unknown result')
      end

      def get_slice(key, column_parent, predicate, consistency_level)
        send_get_slice(key, column_parent, predicate, consistency_level)
        return recv_get_slice()
      end

      def send_get_slice(key, column_parent, predicate, consistency_level)
        send_message('get_slice', Get_slice_args, :key => key, :column_parent => column_parent, :predicate => predicate, :consistency_level => consistency_level)
      end

      def recv_get_slice()
        result = receive_message(Get_slice_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_slice failed: unknown result')
      end

      def get_count(key, column_parent, predicate, consistency_level)
        send_get_count(key, column_parent, predicate, consistency_level)
        return recv_get_count()
      end

      def send_get_count(key, column_parent, predicate, consistency_level)
        send_message('get_count', Get_count_args, :key => key, :column_parent => column_parent, :predicate => predicate, :consistency_level => consistency_level)
      end

      def recv_get_count()
        result = receive_message(Get_count_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_count failed: unknown result')
      end

      def multiget_slice(keys, column_parent, predicate, consistency_level)
        send_multiget_slice(keys, column_parent, predicate, consistency_level)
        return recv_multiget_slice()
      end

      def send_multiget_slice(keys, column_parent, predicate, consistency_level)
        send_message('multiget_slice', Multiget_slice_args, :keys => keys, :column_parent => column_parent, :predicate => predicate, :consistency_level => consistency_level)
      end

      def recv_multiget_slice()
        result = receive_message(Multiget_slice_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'multiget_slice failed: unknown result')
      end

      def multiget_count(keys, column_parent, predicate, consistency_level)
        send_multiget_count(keys, column_parent, predicate, consistency_level)
        return recv_multiget_count()
      end

      def send_multiget_count(keys, column_parent, predicate, consistency_level)
        send_message('multiget_count', Multiget_count_args, :keys => keys, :column_parent => column_parent, :predicate => predicate, :consistency_level => consistency_level)
      end

      def recv_multiget_count()
        result = receive_message(Multiget_count_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'multiget_count failed: unknown result')
      end

      def get_range_slices(column_parent, predicate, range, consistency_level)
        send_get_range_slices(column_parent, predicate, range, consistency_level)
        return recv_get_range_slices()
      end

      def send_get_range_slices(column_parent, predicate, range, consistency_level)
        send_message('get_range_slices', Get_range_slices_args, :column_parent => column_parent, :predicate => predicate, :range => range, :consistency_level => consistency_level)
      end

      def recv_get_range_slices()
        result = receive_message(Get_range_slices_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_range_slices failed: unknown result')
      end

      def get_paged_slice(column_family, range, start_column, consistency_level)
        send_get_paged_slice(column_family, range, start_column, consistency_level)
        return recv_get_paged_slice()
      end

      def send_get_paged_slice(column_family, range, start_column, consistency_level)
        send_message('get_paged_slice', Get_paged_slice_args, :column_family => column_family, :range => range, :start_column => start_column, :consistency_level => consistency_level)
      end

      def recv_get_paged_slice()
        result = receive_message(Get_paged_slice_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_paged_slice failed: unknown result')
      end

      def get_indexed_slices(column_parent, index_clause, column_predicate, consistency_level)
        send_get_indexed_slices(column_parent, index_clause, column_predicate, consistency_level)
        return recv_get_indexed_slices()
      end

      def send_get_indexed_slices(column_parent, index_clause, column_predicate, consistency_level)
        send_message('get_indexed_slices', Get_indexed_slices_args, :column_parent => column_parent, :index_clause => index_clause, :column_predicate => column_predicate, :consistency_level => consistency_level)
      end

      def recv_get_indexed_slices()
        result = receive_message(Get_indexed_slices_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'get_indexed_slices failed: unknown result')
      end

      def insert(key, column_parent, column, consistency_level)
        send_insert(key, column_parent, column, consistency_level)
        recv_insert()
      end

      def send_insert(key, column_parent, column, consistency_level)
        send_message('insert', Insert_args, :key => key, :column_parent => column_parent, :column => column, :consistency_level => consistency_level)
      end

      def recv_insert()
        result = receive_message(Insert_result)
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        return
      end

      def add(key, column_parent, column, consistency_level)
        send_add(key, column_parent, column, consistency_level)
        recv_add()
      end

      def send_add(key, column_parent, column, consistency_level)
        send_message('add', Add_args, :key => key, :column_parent => column_parent, :column => column, :consistency_level => consistency_level)
      end

      def recv_add()
        result = receive_message(Add_result)
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        return
      end

      def remove(key, column_path, timestamp, consistency_level)
        send_remove(key, column_path, timestamp, consistency_level)
        recv_remove()
      end

      def send_remove(key, column_path, timestamp, consistency_level)
        send_message('remove', Remove_args, :key => key, :column_path => column_path, :timestamp => timestamp, :consistency_level => consistency_level)
      end

      def recv_remove()
        result = receive_message(Remove_result)
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        return
      end

      def remove_counter(key, path, consistency_level)
        send_remove_counter(key, path, consistency_level)
        recv_remove_counter()
      end

      def send_remove_counter(key, path, consistency_level)
        send_message('remove_counter', Remove_counter_args, :key => key, :path => path, :consistency_level => consistency_level)
      end

      def recv_remove_counter()
        result = receive_message(Remove_counter_result)
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        return
      end

      def batch_mutate(mutation_map, consistency_level)
        send_batch_mutate(mutation_map, consistency_level)
        recv_batch_mutate()
      end

      def send_batch_mutate(mutation_map, consistency_level)
        send_message('batch_mutate', Batch_mutate_args, :mutation_map => mutation_map, :consistency_level => consistency_level)
      end

      def recv_batch_mutate()
        result = receive_message(Batch_mutate_result)
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        return
      end

      def atomic_batch_mutate(mutation_map, consistency_level)
        send_atomic_batch_mutate(mutation_map, consistency_level)
        recv_atomic_batch_mutate()
      end

      def send_atomic_batch_mutate(mutation_map, consistency_level)
        send_message('atomic_batch_mutate', Atomic_batch_mutate_args, :mutation_map => mutation_map, :consistency_level => consistency_level)
      end

      def recv_atomic_batch_mutate()
        result = receive_message(Atomic_batch_mutate_result)
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        return
      end

      def truncate(cfname)
        send_truncate(cfname)
        recv_truncate()
      end

      def send_truncate(cfname)
        send_message('truncate', Truncate_args, :cfname => cfname)
      end

      def recv_truncate()
        result = receive_message(Truncate_result)
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        return
      end

      def describe_schema_versions()
        send_describe_schema_versions()
        return recv_describe_schema_versions()
      end

      def send_describe_schema_versions()
        send_message('describe_schema_versions', Describe_schema_versions_args)
      end

      def recv_describe_schema_versions()
        result = receive_message(Describe_schema_versions_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_schema_versions failed: unknown result')
      end

      def describe_keyspaces()
        send_describe_keyspaces()
        return recv_describe_keyspaces()
      end

      def send_describe_keyspaces()
        send_message('describe_keyspaces', Describe_keyspaces_args)
      end

      def recv_describe_keyspaces()
        result = receive_message(Describe_keyspaces_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_keyspaces failed: unknown result')
      end

      def describe_cluster_name()
        send_describe_cluster_name()
        return recv_describe_cluster_name()
      end

      def send_describe_cluster_name()
        send_message('describe_cluster_name', Describe_cluster_name_args)
      end

      def recv_describe_cluster_name()
        result = receive_message(Describe_cluster_name_result)
        return result.success unless result.success.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_cluster_name failed: unknown result')
      end

      def describe_version()
        send_describe_version()
        return recv_describe_version()
      end

      def send_describe_version()
        send_message('describe_version', Describe_version_args)
      end

      def recv_describe_version()
        result = receive_message(Describe_version_result)
        return result.success unless result.success.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_version failed: unknown result')
      end

      def describe_ring(keyspace)
        send_describe_ring(keyspace)
        return recv_describe_ring()
      end

      def send_describe_ring(keyspace)
        send_message('describe_ring', Describe_ring_args, :keyspace => keyspace)
      end

      def recv_describe_ring()
        result = receive_message(Describe_ring_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_ring failed: unknown result')
      end

      def describe_token_map()
        send_describe_token_map()
        return recv_describe_token_map()
      end

      def send_describe_token_map()
        send_message('describe_token_map', Describe_token_map_args)
      end

      def recv_describe_token_map()
        result = receive_message(Describe_token_map_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_token_map failed: unknown result')
      end

      def describe_partitioner()
        send_describe_partitioner()
        return recv_describe_partitioner()
      end

      def send_describe_partitioner()
        send_message('describe_partitioner', Describe_partitioner_args)
      end

      def recv_describe_partitioner()
        result = receive_message(Describe_partitioner_result)
        return result.success unless result.success.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_partitioner failed: unknown result')
      end

      def describe_snitch()
        send_describe_snitch()
        return recv_describe_snitch()
      end

      def send_describe_snitch()
        send_message('describe_snitch', Describe_snitch_args)
      end

      def recv_describe_snitch()
        result = receive_message(Describe_snitch_result)
        return result.success unless result.success.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_snitch failed: unknown result')
      end

      def describe_keyspace(keyspace)
        send_describe_keyspace(keyspace)
        return recv_describe_keyspace()
      end

      def send_describe_keyspace(keyspace)
        send_message('describe_keyspace', Describe_keyspace_args, :keyspace => keyspace)
      end

      def recv_describe_keyspace()
        result = receive_message(Describe_keyspace_result)
        return result.success unless result.success.nil?
        raise result.nfe unless result.nfe.nil?
        raise result.ire unless result.ire.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_keyspace failed: unknown result')
      end

      def describe_splits(cfName, start_token, end_token, keys_per_split)
        send_describe_splits(cfName, start_token, end_token, keys_per_split)
        return recv_describe_splits()
      end

      def send_describe_splits(cfName, start_token, end_token, keys_per_split)
        send_message('describe_splits', Describe_splits_args, :cfName => cfName, :start_token => start_token, :end_token => end_token, :keys_per_split => keys_per_split)
      end

      def recv_describe_splits()
        result = receive_message(Describe_splits_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_splits failed: unknown result')
      end

      def trace_next_query()
        send_trace_next_query()
        return recv_trace_next_query()
      end

      def send_trace_next_query()
        send_message('trace_next_query', Trace_next_query_args)
      end

      def recv_trace_next_query()
        result = receive_message(Trace_next_query_result)
        return result.success unless result.success.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'trace_next_query failed: unknown result')
      end

      def describe_splits_ex(cfName, start_token, end_token, keys_per_split)
        send_describe_splits_ex(cfName, start_token, end_token, keys_per_split)
        return recv_describe_splits_ex()
      end

      def send_describe_splits_ex(cfName, start_token, end_token, keys_per_split)
        send_message('describe_splits_ex', Describe_splits_ex_args, :cfName => cfName, :start_token => start_token, :end_token => end_token, :keys_per_split => keys_per_split)
      end

      def recv_describe_splits_ex()
        result = receive_message(Describe_splits_ex_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'describe_splits_ex failed: unknown result')
      end

      def system_add_column_family(cf_def)
        send_system_add_column_family(cf_def)
        return recv_system_add_column_family()
      end

      def send_system_add_column_family(cf_def)
        send_message('system_add_column_family', System_add_column_family_args, :cf_def => cf_def)
      end

      def recv_system_add_column_family()
        result = receive_message(System_add_column_family_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.sde unless result.sde.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'system_add_column_family failed: unknown result')
      end

      def system_drop_column_family(column_family)
        send_system_drop_column_family(column_family)
        return recv_system_drop_column_family()
      end

      def send_system_drop_column_family(column_family)
        send_message('system_drop_column_family', System_drop_column_family_args, :column_family => column_family)
      end

      def recv_system_drop_column_family()
        result = receive_message(System_drop_column_family_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.sde unless result.sde.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'system_drop_column_family failed: unknown result')
      end

      def system_add_keyspace(ks_def)
        send_system_add_keyspace(ks_def)
        return recv_system_add_keyspace()
      end

      def send_system_add_keyspace(ks_def)
        send_message('system_add_keyspace', System_add_keyspace_args, :ks_def => ks_def)
      end

      def recv_system_add_keyspace()
        result = receive_message(System_add_keyspace_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.sde unless result.sde.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'system_add_keyspace failed: unknown result')
      end

      def system_drop_keyspace(keyspace)
        send_system_drop_keyspace(keyspace)
        return recv_system_drop_keyspace()
      end

      def send_system_drop_keyspace(keyspace)
        send_message('system_drop_keyspace', System_drop_keyspace_args, :keyspace => keyspace)
      end

      def recv_system_drop_keyspace()
        result = receive_message(System_drop_keyspace_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.sde unless result.sde.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'system_drop_keyspace failed: unknown result')
      end

      def system_update_keyspace(ks_def)
        send_system_update_keyspace(ks_def)
        return recv_system_update_keyspace()
      end

      def send_system_update_keyspace(ks_def)
        send_message('system_update_keyspace', System_update_keyspace_args, :ks_def => ks_def)
      end

      def recv_system_update_keyspace()
        result = receive_message(System_update_keyspace_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.sde unless result.sde.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'system_update_keyspace failed: unknown result')
      end

      def system_update_column_family(cf_def)
        send_system_update_column_family(cf_def)
        return recv_system_update_column_family()
      end

      def send_system_update_column_family(cf_def)
        send_message('system_update_column_family', System_update_column_family_args, :cf_def => cf_def)
      end

      def recv_system_update_column_family()
        result = receive_message(System_update_column_family_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.sde unless result.sde.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'system_update_column_family failed: unknown result')
      end

      def execute_cql_query(query, compression)
        send_execute_cql_query(query, compression)
        return recv_execute_cql_query()
      end

      def send_execute_cql_query(query, compression)
        send_message('execute_cql_query', Execute_cql_query_args, :query => query, :compression => compression)
      end

      def recv_execute_cql_query()
        result = receive_message(Execute_cql_query_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        raise result.sde unless result.sde.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'execute_cql_query failed: unknown result')
      end

      def execute_cql3_query(query, compression, consistency)
        send_execute_cql3_query(query, compression, consistency)
        return recv_execute_cql3_query()
      end

      def send_execute_cql3_query(query, compression, consistency)
        send_message('execute_cql3_query', Execute_cql3_query_args, :query => query, :compression => compression, :consistency => consistency)
      end

      def recv_execute_cql3_query()
        result = receive_message(Execute_cql3_query_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        raise result.sde unless result.sde.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'execute_cql3_query failed: unknown result')
      end

      def prepare_cql_query(query, compression)
        send_prepare_cql_query(query, compression)
        return recv_prepare_cql_query()
      end

      def send_prepare_cql_query(query, compression)
        send_message('prepare_cql_query', Prepare_cql_query_args, :query => query, :compression => compression)
      end

      def recv_prepare_cql_query()
        result = receive_message(Prepare_cql_query_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'prepare_cql_query failed: unknown result')
      end

      def prepare_cql3_query(query, compression)
        send_prepare_cql3_query(query, compression)
        return recv_prepare_cql3_query()
      end

      def send_prepare_cql3_query(query, compression)
        send_message('prepare_cql3_query', Prepare_cql3_query_args, :query => query, :compression => compression)
      end

      def recv_prepare_cql3_query()
        result = receive_message(Prepare_cql3_query_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'prepare_cql3_query failed: unknown result')
      end

      def execute_prepared_cql_query(itemId, values)
        send_execute_prepared_cql_query(itemId, values)
        return recv_execute_prepared_cql_query()
      end

      def send_execute_prepared_cql_query(itemId, values)
        send_message('execute_prepared_cql_query', Execute_prepared_cql_query_args, :itemId => itemId, :values => values)
      end

      def recv_execute_prepared_cql_query()
        result = receive_message(Execute_prepared_cql_query_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        raise result.sde unless result.sde.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'execute_prepared_cql_query failed: unknown result')
      end

      def execute_prepared_cql3_query(itemId, values, consistency)
        send_execute_prepared_cql3_query(itemId, values, consistency)
        return recv_execute_prepared_cql3_query()
      end

      def send_execute_prepared_cql3_query(itemId, values, consistency)
        send_message('execute_prepared_cql3_query', Execute_prepared_cql3_query_args, :itemId => itemId, :values => values, :consistency => consistency)
      end

      def recv_execute_prepared_cql3_query()
        result = receive_message(Execute_prepared_cql3_query_result)
        return result.success unless result.success.nil?
        raise result.ire unless result.ire.nil?
        raise result.ue unless result.ue.nil?
        raise result.te unless result.te.nil?
        raise result.sde unless result.sde.nil?
        raise ::Thrift::ApplicationException.new(::Thrift::ApplicationException::MISSING_RESULT, 'execute_prepared_cql3_query failed: unknown result')
      end

      def set_cql_version(version)
        send_set_cql_version(version)
        recv_set_cql_version()
      end

      def send_set_cql_version(version)
        send_message('set_cql_version', Set_cql_version_args, :version => version)
      end

      def recv_set_cql_version()
        result = receive_message(Set_cql_version_result)
        raise result.ire unless result.ire.nil?
        return
      end

    end

    class Processor
      include ::Thrift::Processor

      def process_login(seqid, iprot, oprot)
        args = read_args(iprot, Login_args)
        result = Login_result.new()
        begin
          @handler.login(args.auth_request)
        rescue ::CassandraThrift::AuthenticationException => authnx
          result.authnx = authnx
        rescue ::CassandraThrift::AuthorizationException => authzx
          result.authzx = authzx
        end
        write_result(result, oprot, 'login', seqid)
      end

      def process_set_keyspace(seqid, iprot, oprot)
        args = read_args(iprot, Set_keyspace_args)
        result = Set_keyspace_result.new()
        begin
          @handler.set_keyspace(args.keyspace)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        end
        write_result(result, oprot, 'set_keyspace', seqid)
      end

      def process_get(seqid, iprot, oprot)
        args = read_args(iprot, Get_args)
        result = Get_result.new()
        begin
          result.success = @handler.get(args.key, args.column_path, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::NotFoundException => nfe
          result.nfe = nfe
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'get', seqid)
      end

      def process_get_slice(seqid, iprot, oprot)
        args = read_args(iprot, Get_slice_args)
        result = Get_slice_result.new()
        begin
          result.success = @handler.get_slice(args.key, args.column_parent, args.predicate, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'get_slice', seqid)
      end

      def process_get_count(seqid, iprot, oprot)
        args = read_args(iprot, Get_count_args)
        result = Get_count_result.new()
        begin
          result.success = @handler.get_count(args.key, args.column_parent, args.predicate, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'get_count', seqid)
      end

      def process_multiget_slice(seqid, iprot, oprot)
        args = read_args(iprot, Multiget_slice_args)
        result = Multiget_slice_result.new()
        begin
          result.success = @handler.multiget_slice(args.keys, args.column_parent, args.predicate, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'multiget_slice', seqid)
      end

      def process_multiget_count(seqid, iprot, oprot)
        args = read_args(iprot, Multiget_count_args)
        result = Multiget_count_result.new()
        begin
          result.success = @handler.multiget_count(args.keys, args.column_parent, args.predicate, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'multiget_count', seqid)
      end

      def process_get_range_slices(seqid, iprot, oprot)
        args = read_args(iprot, Get_range_slices_args)
        result = Get_range_slices_result.new()
        begin
          result.success = @handler.get_range_slices(args.column_parent, args.predicate, args.range, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'get_range_slices', seqid)
      end

      def process_get_paged_slice(seqid, iprot, oprot)
        args = read_args(iprot, Get_paged_slice_args)
        result = Get_paged_slice_result.new()
        begin
          result.success = @handler.get_paged_slice(args.column_family, args.range, args.start_column, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'get_paged_slice', seqid)
      end

      def process_get_indexed_slices(seqid, iprot, oprot)
        args = read_args(iprot, Get_indexed_slices_args)
        result = Get_indexed_slices_result.new()
        begin
          result.success = @handler.get_indexed_slices(args.column_parent, args.index_clause, args.column_predicate, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'get_indexed_slices', seqid)
      end

      def process_insert(seqid, iprot, oprot)
        args = read_args(iprot, Insert_args)
        result = Insert_result.new()
        begin
          @handler.insert(args.key, args.column_parent, args.column, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'insert', seqid)
      end

      def process_add(seqid, iprot, oprot)
        args = read_args(iprot, Add_args)
        result = Add_result.new()
        begin
          @handler.add(args.key, args.column_parent, args.column, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'add', seqid)
      end

      def process_remove(seqid, iprot, oprot)
        args = read_args(iprot, Remove_args)
        result = Remove_result.new()
        begin
          @handler.remove(args.key, args.column_path, args.timestamp, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'remove', seqid)
      end

      def process_remove_counter(seqid, iprot, oprot)
        args = read_args(iprot, Remove_counter_args)
        result = Remove_counter_result.new()
        begin
          @handler.remove_counter(args.key, args.path, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'remove_counter', seqid)
      end

      def process_batch_mutate(seqid, iprot, oprot)
        args = read_args(iprot, Batch_mutate_args)
        result = Batch_mutate_result.new()
        begin
          @handler.batch_mutate(args.mutation_map, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'batch_mutate', seqid)
      end

      def process_atomic_batch_mutate(seqid, iprot, oprot)
        args = read_args(iprot, Atomic_batch_mutate_args)
        result = Atomic_batch_mutate_result.new()
        begin
          @handler.atomic_batch_mutate(args.mutation_map, args.consistency_level)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'atomic_batch_mutate', seqid)
      end

      def process_truncate(seqid, iprot, oprot)
        args = read_args(iprot, Truncate_args)
        result = Truncate_result.new()
        begin
          @handler.truncate(args.cfname)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        end
        write_result(result, oprot, 'truncate', seqid)
      end

      def process_describe_schema_versions(seqid, iprot, oprot)
        args = read_args(iprot, Describe_schema_versions_args)
        result = Describe_schema_versions_result.new()
        begin
          result.success = @handler.describe_schema_versions()
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        end
        write_result(result, oprot, 'describe_schema_versions', seqid)
      end

      def process_describe_keyspaces(seqid, iprot, oprot)
        args = read_args(iprot, Describe_keyspaces_args)
        result = Describe_keyspaces_result.new()
        begin
          result.success = @handler.describe_keyspaces()
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        end
        write_result(result, oprot, 'describe_keyspaces', seqid)
      end

      def process_describe_cluster_name(seqid, iprot, oprot)
        args = read_args(iprot, Describe_cluster_name_args)
        result = Describe_cluster_name_result.new()
        result.success = @handler.describe_cluster_name()
        write_result(result, oprot, 'describe_cluster_name', seqid)
      end

      def process_describe_version(seqid, iprot, oprot)
        args = read_args(iprot, Describe_version_args)
        result = Describe_version_result.new()
        result.success = @handler.describe_version()
        write_result(result, oprot, 'describe_version', seqid)
      end

      def process_describe_ring(seqid, iprot, oprot)
        args = read_args(iprot, Describe_ring_args)
        result = Describe_ring_result.new()
        begin
          result.success = @handler.describe_ring(args.keyspace)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        end
        write_result(result, oprot, 'describe_ring', seqid)
      end

      def process_describe_token_map(seqid, iprot, oprot)
        args = read_args(iprot, Describe_token_map_args)
        result = Describe_token_map_result.new()
        begin
          result.success = @handler.describe_token_map()
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        end
        write_result(result, oprot, 'describe_token_map', seqid)
      end

      def process_describe_partitioner(seqid, iprot, oprot)
        args = read_args(iprot, Describe_partitioner_args)
        result = Describe_partitioner_result.new()
        result.success = @handler.describe_partitioner()
        write_result(result, oprot, 'describe_partitioner', seqid)
      end

      def process_describe_snitch(seqid, iprot, oprot)
        args = read_args(iprot, Describe_snitch_args)
        result = Describe_snitch_result.new()
        result.success = @handler.describe_snitch()
        write_result(result, oprot, 'describe_snitch', seqid)
      end

      def process_describe_keyspace(seqid, iprot, oprot)
        args = read_args(iprot, Describe_keyspace_args)
        result = Describe_keyspace_result.new()
        begin
          result.success = @handler.describe_keyspace(args.keyspace)
        rescue ::CassandraThrift::NotFoundException => nfe
          result.nfe = nfe
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        end
        write_result(result, oprot, 'describe_keyspace', seqid)
      end

      def process_describe_splits(seqid, iprot, oprot)
        args = read_args(iprot, Describe_splits_args)
        result = Describe_splits_result.new()
        begin
          result.success = @handler.describe_splits(args.cfName, args.start_token, args.end_token, args.keys_per_split)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        end
        write_result(result, oprot, 'describe_splits', seqid)
      end

      def process_trace_next_query(seqid, iprot, oprot)
        args = read_args(iprot, Trace_next_query_args)
        result = Trace_next_query_result.new()
        result.success = @handler.trace_next_query()
        write_result(result, oprot, 'trace_next_query', seqid)
      end

      def process_describe_splits_ex(seqid, iprot, oprot)
        args = read_args(iprot, Describe_splits_ex_args)
        result = Describe_splits_ex_result.new()
        begin
          result.success = @handler.describe_splits_ex(args.cfName, args.start_token, args.end_token, args.keys_per_split)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        end
        write_result(result, oprot, 'describe_splits_ex', seqid)
      end

      def process_system_add_column_family(seqid, iprot, oprot)
        args = read_args(iprot, System_add_column_family_args)
        result = System_add_column_family_result.new()
        begin
          result.success = @handler.system_add_column_family(args.cf_def)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::SchemaDisagreementException => sde
          result.sde = sde
        end
        write_result(result, oprot, 'system_add_column_family', seqid)
      end

      def process_system_drop_column_family(seqid, iprot, oprot)
        args = read_args(iprot, System_drop_column_family_args)
        result = System_drop_column_family_result.new()
        begin
          result.success = @handler.system_drop_column_family(args.column_family)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::SchemaDisagreementException => sde
          result.sde = sde
        end
        write_result(result, oprot, 'system_drop_column_family', seqid)
      end

      def process_system_add_keyspace(seqid, iprot, oprot)
        args = read_args(iprot, System_add_keyspace_args)
        result = System_add_keyspace_result.new()
        begin
          result.success = @handler.system_add_keyspace(args.ks_def)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::SchemaDisagreementException => sde
          result.sde = sde
        end
        write_result(result, oprot, 'system_add_keyspace', seqid)
      end

      def process_system_drop_keyspace(seqid, iprot, oprot)
        args = read_args(iprot, System_drop_keyspace_args)
        result = System_drop_keyspace_result.new()
        begin
          result.success = @handler.system_drop_keyspace(args.keyspace)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::SchemaDisagreementException => sde
          result.sde = sde
        end
        write_result(result, oprot, 'system_drop_keyspace', seqid)
      end

      def process_system_update_keyspace(seqid, iprot, oprot)
        args = read_args(iprot, System_update_keyspace_args)
        result = System_update_keyspace_result.new()
        begin
          result.success = @handler.system_update_keyspace(args.ks_def)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::SchemaDisagreementException => sde
          result.sde = sde
        end
        write_result(result, oprot, 'system_update_keyspace', seqid)
      end

      def process_system_update_column_family(seqid, iprot, oprot)
        args = read_args(iprot, System_update_column_family_args)
        result = System_update_column_family_result.new()
        begin
          result.success = @handler.system_update_column_family(args.cf_def)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::SchemaDisagreementException => sde
          result.sde = sde
        end
        write_result(result, oprot, 'system_update_column_family', seqid)
      end

      def process_execute_cql_query(seqid, iprot, oprot)
        args = read_args(iprot, Execute_cql_query_args)
        result = Execute_cql_query_result.new()
        begin
          result.success = @handler.execute_cql_query(args.query, args.compression)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        rescue ::CassandraThrift::SchemaDisagreementException => sde
          result.sde = sde
        end
        write_result(result, oprot, 'execute_cql_query', seqid)
      end

      def process_execute_cql3_query(seqid, iprot, oprot)
        args = read_args(iprot, Execute_cql3_query_args)
        result = Execute_cql3_query_result.new()
        begin
          result.success = @handler.execute_cql3_query(args.query, args.compression, args.consistency)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        rescue ::CassandraThrift::SchemaDisagreementException => sde
          result.sde = sde
        end
        write_result(result, oprot, 'execute_cql3_query', seqid)
      end

      def process_prepare_cql_query(seqid, iprot, oprot)
        args = read_args(iprot, Prepare_cql_query_args)
        result = Prepare_cql_query_result.new()
        begin
          result.success = @handler.prepare_cql_query(args.query, args.compression)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        end
        write_result(result, oprot, 'prepare_cql_query', seqid)
      end

      def process_prepare_cql3_query(seqid, iprot, oprot)
        args = read_args(iprot, Prepare_cql3_query_args)
        result = Prepare_cql3_query_result.new()
        begin
          result.success = @handler.prepare_cql3_query(args.query, args.compression)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        end
        write_result(result, oprot, 'prepare_cql3_query', seqid)
      end

      def process_execute_prepared_cql_query(seqid, iprot, oprot)
        args = read_args(iprot, Execute_prepared_cql_query_args)
        result = Execute_prepared_cql_query_result.new()
        begin
          result.success = @handler.execute_prepared_cql_query(args.itemId, args.values)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        rescue ::CassandraThrift::SchemaDisagreementException => sde
          result.sde = sde
        end
        write_result(result, oprot, 'execute_prepared_cql_query', seqid)
      end

      def process_execute_prepared_cql3_query(seqid, iprot, oprot)
        args = read_args(iprot, Execute_prepared_cql3_query_args)
        result = Execute_prepared_cql3_query_result.new()
        begin
          result.success = @handler.execute_prepared_cql3_query(args.itemId, args.values, args.consistency)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        rescue ::CassandraThrift::UnavailableException => ue
          result.ue = ue
        rescue ::CassandraThrift::TimedOutException => te
          result.te = te
        rescue ::CassandraThrift::SchemaDisagreementException => sde
          result.sde = sde
        end
        write_result(result, oprot, 'execute_prepared_cql3_query', seqid)
      end

      def process_set_cql_version(seqid, iprot, oprot)
        args = read_args(iprot, Set_cql_version_args)
        result = Set_cql_version_result.new()
        begin
          @handler.set_cql_version(args.version)
        rescue ::CassandraThrift::InvalidRequestException => ire
          result.ire = ire
        end
        write_result(result, oprot, 'set_cql_version', seqid)
      end

    end

    # HELPER FUNCTIONS AND STRUCTURES

    class Login_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      AUTH_REQUEST = 1

      FIELDS = {
        AUTH_REQUEST => {:type => ::Thrift::Types::STRUCT, :name => 'auth_request', :class => ::CassandraThrift::AuthenticationRequest}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field auth_request is unset!') unless @auth_request
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Login_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      AUTHNX = 1
      AUTHZX = 2

      FIELDS = {
        AUTHNX => {:type => ::Thrift::Types::STRUCT, :name => 'authnx', :class => ::CassandraThrift::AuthenticationException},
        AUTHZX => {:type => ::Thrift::Types::STRUCT, :name => 'authzx', :class => ::CassandraThrift::AuthorizationException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Set_keyspace_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEYSPACE = 1

      FIELDS = {
        KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Set_keyspace_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      IRE = 1

      FIELDS = {
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Get_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEY = 1
      COLUMN_PATH = 2
      CONSISTENCY_LEVEL = 3

      FIELDS = {
        KEY => {:type => ::Thrift::Types::STRING, :name => 'key', :binary => true},
        COLUMN_PATH => {:type => ::Thrift::Types::STRUCT, :name => 'column_path', :class => ::CassandraThrift::ColumnPath},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_path is unset!') unless @column_path
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Get_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      NFE = 2
      UE = 3
      TE = 4

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => ::CassandraThrift::ColumnOrSuperColumn},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        NFE => {:type => ::Thrift::Types::STRUCT, :name => 'nfe', :class => ::CassandraThrift::NotFoundException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Get_slice_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEY = 1
      COLUMN_PARENT = 2
      PREDICATE = 3
      CONSISTENCY_LEVEL = 4

      FIELDS = {
        KEY => {:type => ::Thrift::Types::STRING, :name => 'key', :binary => true},
        COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => ::CassandraThrift::ColumnParent},
        PREDICATE => {:type => ::Thrift::Types::STRUCT, :name => 'predicate', :class => ::CassandraThrift::SlicePredicate},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field predicate is unset!') unless @predicate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Get_slice_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => ::CassandraThrift::ColumnOrSuperColumn}},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Get_count_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEY = 1
      COLUMN_PARENT = 2
      PREDICATE = 3
      CONSISTENCY_LEVEL = 4

      FIELDS = {
        KEY => {:type => ::Thrift::Types::STRING, :name => 'key', :binary => true},
        COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => ::CassandraThrift::ColumnParent},
        PREDICATE => {:type => ::Thrift::Types::STRUCT, :name => 'predicate', :class => ::CassandraThrift::SlicePredicate},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field predicate is unset!') unless @predicate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Get_count_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::I32, :name => 'success'},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Multiget_slice_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEYS = 1
      COLUMN_PARENT = 2
      PREDICATE = 3
      CONSISTENCY_LEVEL = 4

      FIELDS = {
        KEYS => {:type => ::Thrift::Types::LIST, :name => 'keys', :element => {:type => ::Thrift::Types::STRING, :binary => true}},
        COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => ::CassandraThrift::ColumnParent},
        PREDICATE => {:type => ::Thrift::Types::STRUCT, :name => 'predicate', :class => ::CassandraThrift::SlicePredicate},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keys is unset!') unless @keys
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field predicate is unset!') unless @predicate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Multiget_slice_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::MAP, :name => 'success', :key => {:type => ::Thrift::Types::STRING, :binary => true}, :value => {:type => ::Thrift::Types::LIST, :element => {:type => ::Thrift::Types::STRUCT, :class => ::CassandraThrift::ColumnOrSuperColumn}}},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Multiget_count_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEYS = 1
      COLUMN_PARENT = 2
      PREDICATE = 3
      CONSISTENCY_LEVEL = 4

      FIELDS = {
        KEYS => {:type => ::Thrift::Types::LIST, :name => 'keys', :element => {:type => ::Thrift::Types::STRING, :binary => true}},
        COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => ::CassandraThrift::ColumnParent},
        PREDICATE => {:type => ::Thrift::Types::STRUCT, :name => 'predicate', :class => ::CassandraThrift::SlicePredicate},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keys is unset!') unless @keys
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field predicate is unset!') unless @predicate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Multiget_count_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::MAP, :name => 'success', :key => {:type => ::Thrift::Types::STRING, :binary => true}, :value => {:type => ::Thrift::Types::I32}},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Get_range_slices_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      COLUMN_PARENT = 1
      PREDICATE = 2
      RANGE = 3
      CONSISTENCY_LEVEL = 4

      FIELDS = {
        COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => ::CassandraThrift::ColumnParent},
        PREDICATE => {:type => ::Thrift::Types::STRUCT, :name => 'predicate', :class => ::CassandraThrift::SlicePredicate},
        RANGE => {:type => ::Thrift::Types::STRUCT, :name => 'range', :class => ::CassandraThrift::KeyRange},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field predicate is unset!') unless @predicate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field range is unset!') unless @range
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Get_range_slices_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => ::CassandraThrift::KeySlice}},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Get_paged_slice_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      COLUMN_FAMILY = 1
      RANGE = 2
      START_COLUMN = 3
      CONSISTENCY_LEVEL = 4

      FIELDS = {
        COLUMN_FAMILY => {:type => ::Thrift::Types::STRING, :name => 'column_family'},
        RANGE => {:type => ::Thrift::Types::STRUCT, :name => 'range', :class => ::CassandraThrift::KeyRange},
        START_COLUMN => {:type => ::Thrift::Types::STRING, :name => 'start_column', :binary => true},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_family is unset!') unless @column_family
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field range is unset!') unless @range
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field start_column is unset!') unless @start_column
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Get_paged_slice_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => ::CassandraThrift::KeySlice}},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Get_indexed_slices_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      COLUMN_PARENT = 1
      INDEX_CLAUSE = 2
      COLUMN_PREDICATE = 3
      CONSISTENCY_LEVEL = 4

      FIELDS = {
        COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => ::CassandraThrift::ColumnParent},
        INDEX_CLAUSE => {:type => ::Thrift::Types::STRUCT, :name => 'index_clause', :class => ::CassandraThrift::IndexClause},
        COLUMN_PREDICATE => {:type => ::Thrift::Types::STRUCT, :name => 'column_predicate', :class => ::CassandraThrift::SlicePredicate},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field index_clause is unset!') unless @index_clause
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_predicate is unset!') unless @column_predicate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Get_indexed_slices_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => ::CassandraThrift::KeySlice}},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Insert_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEY = 1
      COLUMN_PARENT = 2
      COLUMN = 3
      CONSISTENCY_LEVEL = 4

      FIELDS = {
        KEY => {:type => ::Thrift::Types::STRING, :name => 'key', :binary => true},
        COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => ::CassandraThrift::ColumnParent},
        COLUMN => {:type => ::Thrift::Types::STRUCT, :name => 'column', :class => ::CassandraThrift::Column},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column is unset!') unless @column
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Insert_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Add_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEY = 1
      COLUMN_PARENT = 2
      COLUMN = 3
      CONSISTENCY_LEVEL = 4

      FIELDS = {
        KEY => {:type => ::Thrift::Types::STRING, :name => 'key', :binary => true},
        COLUMN_PARENT => {:type => ::Thrift::Types::STRUCT, :name => 'column_parent', :class => ::CassandraThrift::ColumnParent},
        COLUMN => {:type => ::Thrift::Types::STRUCT, :name => 'column', :class => ::CassandraThrift::CounterColumn},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_parent is unset!') unless @column_parent
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column is unset!') unless @column
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Add_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Remove_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEY = 1
      COLUMN_PATH = 2
      TIMESTAMP = 3
      CONSISTENCY_LEVEL = 4

      FIELDS = {
        KEY => {:type => ::Thrift::Types::STRING, :name => 'key', :binary => true},
        COLUMN_PATH => {:type => ::Thrift::Types::STRUCT, :name => 'column_path', :class => ::CassandraThrift::ColumnPath},
        TIMESTAMP => {:type => ::Thrift::Types::I64, :name => 'timestamp'},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_path is unset!') unless @column_path
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field timestamp is unset!') unless @timestamp
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Remove_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Remove_counter_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEY = 1
      PATH = 2
      CONSISTENCY_LEVEL = 3

      FIELDS = {
        KEY => {:type => ::Thrift::Types::STRING, :name => 'key', :binary => true},
        PATH => {:type => ::Thrift::Types::STRUCT, :name => 'path', :class => ::CassandraThrift::ColumnPath},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field key is unset!') unless @key
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field path is unset!') unless @path
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Remove_counter_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Batch_mutate_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      MUTATION_MAP = 1
      CONSISTENCY_LEVEL = 2

      FIELDS = {
        MUTATION_MAP => {:type => ::Thrift::Types::MAP, :name => 'mutation_map', :key => {:type => ::Thrift::Types::STRING, :binary => true}, :value => {:type => ::Thrift::Types::MAP, :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::LIST, :element => {:type => ::Thrift::Types::STRUCT, :class => ::CassandraThrift::Mutation}}}},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field mutation_map is unset!') unless @mutation_map
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Batch_mutate_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Atomic_batch_mutate_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      MUTATION_MAP = 1
      CONSISTENCY_LEVEL = 2

      FIELDS = {
        MUTATION_MAP => {:type => ::Thrift::Types::MAP, :name => 'mutation_map', :key => {:type => ::Thrift::Types::STRING, :binary => true}, :value => {:type => ::Thrift::Types::MAP, :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::LIST, :element => {:type => ::Thrift::Types::STRUCT, :class => ::CassandraThrift::Mutation}}}},
        CONSISTENCY_LEVEL => {:type => ::Thrift::Types::I32, :name => 'consistency_level', :default =>         1, :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field mutation_map is unset!') unless @mutation_map
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency_level is unset!') unless @consistency_level
        unless @consistency_level.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency_level)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency_level!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Atomic_batch_mutate_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Truncate_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      CFNAME = 1

      FIELDS = {
        CFNAME => {:type => ::Thrift::Types::STRING, :name => 'cfname'}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field cfname is unset!') unless @cfname
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Truncate_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      IRE = 1
      UE = 2
      TE = 3

      FIELDS = {
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_schema_versions_args
      include ::Thrift::Struct, ::Thrift::Struct_Union

      FIELDS = {

      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_schema_versions_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::MAP, :name => 'success', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::LIST, :element => {:type => ::Thrift::Types::STRING}}},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_keyspaces_args
      include ::Thrift::Struct, ::Thrift::Struct_Union

      FIELDS = {

      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_keyspaces_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => ::CassandraThrift::KsDef}},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_cluster_name_args
      include ::Thrift::Struct, ::Thrift::Struct_Union

      FIELDS = {

      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_cluster_name_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_version_args
      include ::Thrift::Struct, ::Thrift::Struct_Union

      FIELDS = {

      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_version_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_ring_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEYSPACE = 1

      FIELDS = {
        KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_ring_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => ::CassandraThrift::TokenRange}},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_token_map_args
      include ::Thrift::Struct, ::Thrift::Struct_Union

      FIELDS = {

      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_token_map_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::MAP, :name => 'success', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::STRING}},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_partitioner_args
      include ::Thrift::Struct, ::Thrift::Struct_Union

      FIELDS = {

      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_partitioner_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_snitch_args
      include ::Thrift::Struct, ::Thrift::Struct_Union

      FIELDS = {

      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_snitch_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_keyspace_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEYSPACE = 1

      FIELDS = {
        KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_keyspace_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      NFE = 1
      IRE = 2

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => ::CassandraThrift::KsDef},
        NFE => {:type => ::Thrift::Types::STRUCT, :name => 'nfe', :class => ::CassandraThrift::NotFoundException},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_splits_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      CFNAME = 1
      START_TOKEN = 2
      END_TOKEN = 3
      KEYS_PER_SPLIT = 4

      FIELDS = {
        CFNAME => {:type => ::Thrift::Types::STRING, :name => 'cfName'},
        START_TOKEN => {:type => ::Thrift::Types::STRING, :name => 'start_token'},
        END_TOKEN => {:type => ::Thrift::Types::STRING, :name => 'end_token'},
        KEYS_PER_SPLIT => {:type => ::Thrift::Types::I32, :name => 'keys_per_split'}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field cfName is unset!') unless @cfName
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field start_token is unset!') unless @start_token
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field end_token is unset!') unless @end_token
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keys_per_split is unset!') unless @keys_per_split
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_splits_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRING}},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Trace_next_query_args
      include ::Thrift::Struct, ::Thrift::Struct_Union

      FIELDS = {

      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Trace_next_query_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success', :binary => true}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_splits_ex_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      CFNAME = 1
      START_TOKEN = 2
      END_TOKEN = 3
      KEYS_PER_SPLIT = 4

      FIELDS = {
        CFNAME => {:type => ::Thrift::Types::STRING, :name => 'cfName'},
        START_TOKEN => {:type => ::Thrift::Types::STRING, :name => 'start_token'},
        END_TOKEN => {:type => ::Thrift::Types::STRING, :name => 'end_token'},
        KEYS_PER_SPLIT => {:type => ::Thrift::Types::I32, :name => 'keys_per_split'}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field cfName is unset!') unless @cfName
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field start_token is unset!') unless @start_token
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field end_token is unset!') unless @end_token
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keys_per_split is unset!') unless @keys_per_split
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Describe_splits_ex_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::LIST, :name => 'success', :element => {:type => ::Thrift::Types::STRUCT, :class => ::CassandraThrift::CfSplit}},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class System_add_column_family_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      CF_DEF = 1

      FIELDS = {
        CF_DEF => {:type => ::Thrift::Types::STRUCT, :name => 'cf_def', :class => ::CassandraThrift::CfDef}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field cf_def is unset!') unless @cf_def
      end

      ::Thrift::Struct.generate_accessors self
    end

    class System_add_column_family_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      SDE = 2

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        SDE => {:type => ::Thrift::Types::STRUCT, :name => 'sde', :class => ::CassandraThrift::SchemaDisagreementException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class System_drop_column_family_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      COLUMN_FAMILY = 1

      FIELDS = {
        COLUMN_FAMILY => {:type => ::Thrift::Types::STRING, :name => 'column_family'}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field column_family is unset!') unless @column_family
      end

      ::Thrift::Struct.generate_accessors self
    end

    class System_drop_column_family_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      SDE = 2

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        SDE => {:type => ::Thrift::Types::STRUCT, :name => 'sde', :class => ::CassandraThrift::SchemaDisagreementException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class System_add_keyspace_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KS_DEF = 1

      FIELDS = {
        KS_DEF => {:type => ::Thrift::Types::STRUCT, :name => 'ks_def', :class => ::CassandraThrift::KsDef}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field ks_def is unset!') unless @ks_def
      end

      ::Thrift::Struct.generate_accessors self
    end

    class System_add_keyspace_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      SDE = 2

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        SDE => {:type => ::Thrift::Types::STRUCT, :name => 'sde', :class => ::CassandraThrift::SchemaDisagreementException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class System_drop_keyspace_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KEYSPACE = 1

      FIELDS = {
        KEYSPACE => {:type => ::Thrift::Types::STRING, :name => 'keyspace'}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field keyspace is unset!') unless @keyspace
      end

      ::Thrift::Struct.generate_accessors self
    end

    class System_drop_keyspace_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      SDE = 2

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        SDE => {:type => ::Thrift::Types::STRUCT, :name => 'sde', :class => ::CassandraThrift::SchemaDisagreementException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class System_update_keyspace_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      KS_DEF = 1

      FIELDS = {
        KS_DEF => {:type => ::Thrift::Types::STRUCT, :name => 'ks_def', :class => ::CassandraThrift::KsDef}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field ks_def is unset!') unless @ks_def
      end

      ::Thrift::Struct.generate_accessors self
    end

    class System_update_keyspace_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      SDE = 2

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        SDE => {:type => ::Thrift::Types::STRUCT, :name => 'sde', :class => ::CassandraThrift::SchemaDisagreementException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class System_update_column_family_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      CF_DEF = 1

      FIELDS = {
        CF_DEF => {:type => ::Thrift::Types::STRUCT, :name => 'cf_def', :class => ::CassandraThrift::CfDef}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field cf_def is unset!') unless @cf_def
      end

      ::Thrift::Struct.generate_accessors self
    end

    class System_update_column_family_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      SDE = 2

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRING, :name => 'success'},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        SDE => {:type => ::Thrift::Types::STRUCT, :name => 'sde', :class => ::CassandraThrift::SchemaDisagreementException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Execute_cql_query_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      QUERY = 1
      COMPRESSION = 2

      FIELDS = {
        QUERY => {:type => ::Thrift::Types::STRING, :name => 'query', :binary => true},
        COMPRESSION => {:type => ::Thrift::Types::I32, :name => 'compression', :enum_class => ::CassandraThrift::Compression}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field query is unset!') unless @query
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field compression is unset!') unless @compression
        unless @compression.nil? || ::CassandraThrift::Compression::VALID_VALUES.include?(@compression)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field compression!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Execute_cql_query_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      UE = 2
      TE = 3
      SDE = 4

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => ::CassandraThrift::CqlResult},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException},
        SDE => {:type => ::Thrift::Types::STRUCT, :name => 'sde', :class => ::CassandraThrift::SchemaDisagreementException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Execute_cql3_query_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      QUERY = 1
      COMPRESSION = 2
      CONSISTENCY = 3

      FIELDS = {
        QUERY => {:type => ::Thrift::Types::STRING, :name => 'query', :binary => true},
        COMPRESSION => {:type => ::Thrift::Types::I32, :name => 'compression', :enum_class => ::CassandraThrift::Compression},
        CONSISTENCY => {:type => ::Thrift::Types::I32, :name => 'consistency', :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field query is unset!') unless @query
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field compression is unset!') unless @compression
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency is unset!') unless @consistency
        unless @compression.nil? || ::CassandraThrift::Compression::VALID_VALUES.include?(@compression)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field compression!')
        end
        unless @consistency.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Execute_cql3_query_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      UE = 2
      TE = 3
      SDE = 4

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => ::CassandraThrift::CqlResult},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException},
        SDE => {:type => ::Thrift::Types::STRUCT, :name => 'sde', :class => ::CassandraThrift::SchemaDisagreementException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Prepare_cql_query_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      QUERY = 1
      COMPRESSION = 2

      FIELDS = {
        QUERY => {:type => ::Thrift::Types::STRING, :name => 'query', :binary => true},
        COMPRESSION => {:type => ::Thrift::Types::I32, :name => 'compression', :enum_class => ::CassandraThrift::Compression}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field query is unset!') unless @query
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field compression is unset!') unless @compression
        unless @compression.nil? || ::CassandraThrift::Compression::VALID_VALUES.include?(@compression)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field compression!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Prepare_cql_query_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => ::CassandraThrift::CqlPreparedResult},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Prepare_cql3_query_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      QUERY = 1
      COMPRESSION = 2

      FIELDS = {
        QUERY => {:type => ::Thrift::Types::STRING, :name => 'query', :binary => true},
        COMPRESSION => {:type => ::Thrift::Types::I32, :name => 'compression', :enum_class => ::CassandraThrift::Compression}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field query is unset!') unless @query
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field compression is unset!') unless @compression
        unless @compression.nil? || ::CassandraThrift::Compression::VALID_VALUES.include?(@compression)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field compression!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Prepare_cql3_query_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => ::CassandraThrift::CqlPreparedResult},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Execute_prepared_cql_query_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      ITEMID = 1
      VALUES = 2

      FIELDS = {
        ITEMID => {:type => ::Thrift::Types::I32, :name => 'itemId'},
        VALUES => {:type => ::Thrift::Types::LIST, :name => 'values', :element => {:type => ::Thrift::Types::STRING, :binary => true}}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field itemId is unset!') unless @itemId
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field values is unset!') unless @values
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Execute_prepared_cql_query_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      UE = 2
      TE = 3
      SDE = 4

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => ::CassandraThrift::CqlResult},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException},
        SDE => {:type => ::Thrift::Types::STRUCT, :name => 'sde', :class => ::CassandraThrift::SchemaDisagreementException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Execute_prepared_cql3_query_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      ITEMID = 1
      VALUES = 2
      CONSISTENCY = 3

      FIELDS = {
        ITEMID => {:type => ::Thrift::Types::I32, :name => 'itemId'},
        VALUES => {:type => ::Thrift::Types::LIST, :name => 'values', :element => {:type => ::Thrift::Types::STRING, :binary => true}},
        CONSISTENCY => {:type => ::Thrift::Types::I32, :name => 'consistency', :enum_class => ::CassandraThrift::ConsistencyLevel}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field itemId is unset!') unless @itemId
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field values is unset!') unless @values
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field consistency is unset!') unless @consistency
        unless @consistency.nil? || ::CassandraThrift::ConsistencyLevel::VALID_VALUES.include?(@consistency)
          raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Invalid value of field consistency!')
        end
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Execute_prepared_cql3_query_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      SUCCESS = 0
      IRE = 1
      UE = 2
      TE = 3
      SDE = 4

      FIELDS = {
        SUCCESS => {:type => ::Thrift::Types::STRUCT, :name => 'success', :class => ::CassandraThrift::CqlResult},
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException},
        UE => {:type => ::Thrift::Types::STRUCT, :name => 'ue', :class => ::CassandraThrift::UnavailableException},
        TE => {:type => ::Thrift::Types::STRUCT, :name => 'te', :class => ::CassandraThrift::TimedOutException},
        SDE => {:type => ::Thrift::Types::STRUCT, :name => 'sde', :class => ::CassandraThrift::SchemaDisagreementException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Set_cql_version_args
      include ::Thrift::Struct, ::Thrift::Struct_Union
      VERSION = 1

      FIELDS = {
        VERSION => {:type => ::Thrift::Types::STRING, :name => 'version'}
      }

      def struct_fields; FIELDS; end

      def validate
        raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field version is unset!') unless @version
      end

      ::Thrift::Struct.generate_accessors self
    end

    class Set_cql_version_result
      include ::Thrift::Struct, ::Thrift::Struct_Union
      IRE = 1

      FIELDS = {
        IRE => {:type => ::Thrift::Types::STRUCT, :name => 'ire', :class => ::CassandraThrift::InvalidRequestException}
      }

      def struct_fields; FIELDS; end

      def validate
      end

      ::Thrift::Struct.generate_accessors self
    end

  end

end
