/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");
XPCOMUtils.defineLazyModuleGetter(this, "Services", "resource://gre/modules/Services.jsm");

this.EXPORTED_SYMBOLS = ["AppConstants"];

// Immutable for export.
this.AppConstants = Object.freeze({
  // See this wiki page for more details about channel specific build
  // defines: https://wiki.mozilla.org/Platform/Channel-specific_build_defines
  NIGHTLY_BUILD:
//@line 22 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 24 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  RELEASE_OR_BETA:
//@line 27 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  true,
//@line 31 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  ACCESSIBILITY:
//@line 34 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  true,
//@line 38 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  // Official corresponds, roughly, to whether this build is performed
  // on Mozilla's continuous integration infrastructure. You should
  // disable developer-only functionality when this flag is set.
  MOZILLA_OFFICIAL:
//@line 46 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 48 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_OFFICIAL_BRANDING:
//@line 53 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 55 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_DEV_EDITION:
//@line 60 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 62 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_HEALTHREPORT:
//@line 67 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 69 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_DATA_REPORTING:
//@line 74 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 76 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_SANDBOX:
//@line 81 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 83 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_CONTENT_SANDBOX:
//@line 88 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 90 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_REPORTING:
//@line 95 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 97 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_ON_BY_DEFAULT:
//@line 102 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 104 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_CLOUDSYNC:
//@line 107 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  true,
//@line 111 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_UPDATER:
//@line 116 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 118 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_SWITCHBOARD:
//@line 123 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 125 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_WEBRTC:
//@line 130 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 132 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_WIDGET_GTK:
//@line 135 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  true,
//@line 139 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

//@line 141 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  MOZ_B2G:
//@line 145 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 147 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  XP_UNIX:
//@line 150 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  true,
//@line 154 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

//@line 157 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  platform:
//@line 159 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  "linux",
//@line 173 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  isPlatformAndVersionAtLeast(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) >= 0;
  },

  isPlatformAndVersionAtMost(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) <= 0;
  },

  MOZ_CRASHREPORTER:
//@line 190 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 192 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_VERIFY_MAR_SIGNATURE:
//@line 197 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 199 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_MAINTENANCE_SERVICE:
//@line 204 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 206 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  E10S_TESTING_ONLY:
//@line 211 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 213 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  DEBUG:
//@line 218 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 220 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  ASAN:
//@line 225 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 227 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_B2G_RIL:
//@line 232 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 234 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_GRAPHENE:
//@line 239 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 241 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_SYSTEM_NSS:
//@line 244 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  true,
//@line 248 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_PLACES:
//@line 251 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  true,
//@line 255 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_REQUIRE_SIGNING:
//@line 260 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 262 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MENUBAR_CAN_AUTOHIDE:
//@line 265 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  true,
//@line 269 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  CAN_DRAW_IN_TITLEBAR:
//@line 274 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 276 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_HISTORY:
//@line 281 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 283 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_TOOLKIT_SEARCH:
//@line 286 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  true,
//@line 290 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_ENABLE_PROFILER_SPS:
//@line 295 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 297 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_ACTIVITY_STREAM:
//@line 302 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  false,
//@line 304 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  DLL_PREFIX: "lib",
  DLL_SUFFIX: ".so",

  MOZ_APP_NAME: "seamonkey",
  MOZ_APP_VERSION: "2.49.4",
  MOZ_APP_VERSION_DISPLAY: "2.49.4",
  MOZ_BUILD_APP: "../suite",
  MOZ_MACBUNDLE_NAME: "SeaMonkey.app",
  MOZ_UPDATE_CHANNEL: "default",
  INSTALL_LOCALE: "en-US",
  MOZ_WIDGET_TOOLKIT: "gtk2",
  ANDROID_PACKAGE_NAME: "org.mozilla.seamonkey",
  MOZ_B2G_VERSION: "1.0.0",
  MOZ_B2G_OS_NAME: "",

  DEBUG_JS_MODULES: "",

  // URL to the hg revision this was built from (e.g.
  // "https://hg.mozilla.org/mozilla-central/rev/6256ec9113c1")
  // On unofficial builds, this is an empty string.
//@line 328 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
  SOURCE_REVISION_URL: "",

  HAVE_USR_LIB64_DIR:
//@line 334 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
    false,
//@line 336 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"

  HAVE_SHELL_SERVICE:
//@line 339 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
    true,
//@line 343 "/usr/pkgsrc/www/seamonkey/work/seamonkey-2.49.4/mozilla/toolkit/modules/AppConstants.jsm"
});
