/* ISC license. */

#ifndef UINT32_H
#define UINT32_H

#include <sys/types.h>
#include <stdint.h>

#define uint32_little_endian(s, n)
#define uint32_big_endian(s, n) uint32_reverse((s), (n))

#define uint32_little(u) (u)
#define uint32_big(u) uint32_bswap(u)

extern void uint32_pack (char *, uint32_t) ;
extern void uint32_pack_big (char *, uint32_t) ;
extern void uint32_unpack (char const *, uint32_t *) ;
extern void uint32_unpack_big (char const *, uint32_t *) ;
extern void uint32_reverse (char *, size_t) ;
extern uint32_t uint32_bswap (uint32_t) ;

#define UINT32_FMT 11
#define UINT32_OFMT 13
#define UINT32_XFMT 9
#define UINT32_BFMT 33

extern size_t uint32_fmt_base (char *, uint32_t, unsigned int) ;
extern size_t uint320_fmt_base (char *, uint32_t, size_t, unsigned int) ;

#define uint32_fmt(s, u) uint32_fmt_base(s, (u), 10)
#define uint320_fmt(s, u, n) uint320_fmt_base(s, u, (n), 10)
#define uint32_ofmt(s, o) uint32_fmt_base(s, (o), 8)
#define uint320_ofmt(s, o, n) uint320_fmt_base(s, o, (n), 8)
#define uint32_xfmt(s, x) uint32_fmt_base(s, (x), 16)
#define uint320_xfmt(s, x, n) uint320_fmt_base(s, x, (n), 16)
#define uint32_bfmt(s, b) uint320_fmt_base(s, (b), 2)
#define uint320_bfmt(s, b, n) uint320_fmt_base(s, b, (n), 2)

extern size_t uint32_fmtlist (char *, uint32_t const *, size_t) ;

extern size_t uint32_scan_base (char const *, uint32_t *, unsigned int) ;
extern size_t uint320_scan_base (char const *, uint32_t *, unsigned int) ;

#define uint32_scan(s, u) uint32_scan_base(s, (u), 10)
#define uint320_scan(s, u) uint320_scan_base(s, (u), 10)
#define uint32_oscan(s, u) uint32_scan_base(s, (u), 8)
#define uint320_oscan(s, u) uint320_scan_base(s, (u), 8)
#define uint32_xscan(s, u) uint32_scan_base(s, (u), 16)
#define uint320_xscan(s, u) uint320_scan_base(s, (u), 16)
#define uint32_bscan(s, u) uint32_scan_base(s, (u), 2)
#define uint320_bscan(s, u) uint320_scan_base(s, (u), 2)

extern size_t uint32_scanlist (uint32_t *, size_t, char const *, size_t *) ;

extern size_t int32_fmt (char *, int32_t) ;
extern size_t int32_fmtlist (char *, int32_t const *, size_t) ;
extern size_t int32_scan (char const *, int32_t *) ;
extern size_t int320_scan (char const *, int32_t *) ;
extern size_t int32_scanlist (int32_t *, size_t, char const *, size_t *) ;

typedef uint32_t uint32 ;

#endif
