/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

ChromeUtils.import("resource://gre/modules/XPCOMUtils.jsm");
ChromeUtils.defineModuleGetter(this, "Services", "resource://gre/modules/Services.jsm");
ChromeUtils.defineModuleGetter(this, "AddonManager", "resource://gre/modules/AddonManager.jsm");

this.EXPORTED_SYMBOLS = ["AppConstants"];

// Immutable for export.
this.AppConstants = Object.freeze({
  // See this wiki page for more details about channel specific build
  // defines: https://wiki.mozilla.org/Platform/Channel-specific_build_defines
  NIGHTLY_BUILD:
//@line 23 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 25 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  RELEASE_OR_BETA:
//@line 28 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  true,
//@line 32 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  EARLY_BETA_OR_EARLIER:
//@line 37 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 39 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  ACCESSIBILITY:
//@line 42 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  true,
//@line 46 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  // Official corresponds, roughly, to whether this build is performed
  // on Mozilla's continuous integration infrastructure. You should
  // disable developer-only functionality when this flag is set.
  MOZILLA_OFFICIAL:
//@line 54 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 56 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_OFFICIAL_BRANDING:
//@line 61 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 63 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_DEV_EDITION:
//@line 68 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 70 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_HEALTHREPORT:
//@line 75 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 77 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_DATA_REPORTING:
//@line 82 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 84 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_SANDBOX:
//@line 89 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 91 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_CONTENT_SANDBOX:
//@line 96 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 98 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_REPORTING:
//@line 103 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 105 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_ON_BY_DEFAULT:
//@line 110 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 112 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_UPDATER:
//@line 117 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 119 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_SWITCHBOARD:
//@line 124 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 126 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_WEBRTC:
//@line 131 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 133 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_WIDGET_GTK:
//@line 136 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  true,
//@line 140 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  XP_UNIX:
//@line 143 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  true,
//@line 147 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

//@line 150 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  platform:
//@line 152 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  "linux",
//@line 164 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  isPlatformAndVersionAtLeast(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) >= 0;
  },

  isPlatformAndVersionAtMost(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) <= 0;
  },

  MOZ_CRASHREPORTER:
//@line 181 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 183 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_MAINTENANCE_SERVICE:
//@line 188 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 190 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  DEBUG:
//@line 195 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 197 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  ASAN:
//@line 202 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 204 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_GRAPHENE:
//@line 209 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 211 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_SYSTEM_NSS:
//@line 214 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  true,
//@line 218 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_PLACES:
//@line 221 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  true,
//@line 225 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_ADDON_SIGNING:
//@line 230 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 232 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_REQUIRE_SIGNING:
//@line 237 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 239 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  get MOZ_UNSIGNED_SCOPES() {
    let result = 0;
//@line 248 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
    return result;
  },

  MOZ_ALLOW_LEGACY_EXTENSIONS:
//@line 253 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  true,
//@line 257 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MENUBAR_CAN_AUTOHIDE:
//@line 260 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  true,
//@line 264 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  CAN_DRAW_IN_TITLEBAR:
//@line 267 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  true,
//@line 271 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_HISTORY:
//@line 276 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 278 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_TOOLKIT_SEARCH:
//@line 281 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  true,
//@line 285 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_GECKO_PROFILER:
//@line 290 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 292 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_ACTIVITY_STREAM:
//@line 297 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 299 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_MOZILLA_ONLINE:
//@line 304 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  false,
//@line 306 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  DLL_PREFIX: "lib",
  DLL_SUFFIX: ".so",

  MOZ_APP_NAME: "thunderbird",
  MOZ_APP_VERSION: "60.5.1",
  MOZ_APP_VERSION_DISPLAY: "60.5.1",
  MOZ_BUILD_APP: "comm/mail",
  MOZ_MACBUNDLE_NAME: "Thunderbird Daily.app",
  MOZ_UPDATE_CHANNEL: "default",
  INSTALL_LOCALE: "en-US",
  MOZ_WIDGET_TOOLKIT: "gtk3",
  ANDROID_PACKAGE_NAME: "org.mozilla.thunderbird",

  DEBUG_JS_MODULES: "",

  MOZ_BING_API_CLIENTID: "no-bing-api-clientid",
  MOZ_BING_API_KEY: "no-bing-api-key",
  MOZ_GOOGLE_API_KEY: "no-google-api-key",
  MOZ_MOZILLA_API_KEY: "no-mozilla-api-key",

  // URL to the hg revision this was built from (e.g.
  // "https://hg.mozilla.org/mozilla-central/rev/6256ec9113c1")
  // On unofficial builds, this is an empty string.
//@line 333 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
  SOURCE_REVISION_URL: "",

  HAVE_USR_LIB64_DIR:
//@line 339 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
    false,
//@line 341 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  HAVE_SHELL_SERVICE:
//@line 344 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
    true,
//@line 348 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

  MOZ_STYLO:
//@line 351 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"
    true,
//@line 355 "/usr/pkgsrc/mail/thunderbird/work/thunderbird-60.5.1/toolkit/modules/AppConstants.jsm"

});
